/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.integration.mongodb.store.AbstractConfigurableMongoDbMessageStore;
import org.springframework.integration.mongodb.store.MessageDocument;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupMetadata;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class ConfigurableMongoDbMessageStore
extends AbstractConfigurableMongoDbMessageStore
implements MessageStore {
    public static final String DEFAULT_COLLECTION_NAME = "configurableStoreMessages";
    private final Collection<MessageGroupStore.MessageGroupCallback> expiryCallbacks = new LinkedHashSet<MessageGroupStore.MessageGroupCallback>();
    private volatile boolean timeoutOnIdle;

    public ConfigurableMongoDbMessageStore(MongoTemplate mongoTemplate) {
        this(mongoTemplate, DEFAULT_COLLECTION_NAME);
    }

    public ConfigurableMongoDbMessageStore(MongoTemplate mongoTemplate, String collectionName) {
        super(mongoTemplate, collectionName);
    }

    public ConfigurableMongoDbMessageStore(MongoDbFactory mongoDbFactory) {
        this(mongoDbFactory, null, DEFAULT_COLLECTION_NAME);
    }

    public ConfigurableMongoDbMessageStore(MongoDbFactory mongoDbFactory, MappingMongoConverter mappingMongoConverter) {
        this(mongoDbFactory, mappingMongoConverter, DEFAULT_COLLECTION_NAME);
    }

    public ConfigurableMongoDbMessageStore(MongoDbFactory mongoDbFactory, String collectionName) {
        this(mongoDbFactory, null, collectionName);
    }

    public ConfigurableMongoDbMessageStore(MongoDbFactory mongoDbFactory, MappingMongoConverter mappingMongoConverter, String collectionName) {
        super(mongoDbFactory, mappingMongoConverter, collectionName);
    }

    public void setExpiryCallbacks(Collection<MessageGroupStore.MessageGroupCallback> expiryCallbacks) {
        for (MessageGroupStore.MessageGroupCallback callback : expiryCallbacks) {
            this.registerMessageGroupExpiryCallback(callback);
        }
    }

    public boolean isTimeoutOnIdle() {
        return this.timeoutOnIdle;
    }

    public void setTimeoutOnIdle(boolean timeoutOnIdle) {
        this.timeoutOnIdle = timeoutOnIdle;
    }

    public <T> Message<T> addMessage(Message<T> message) {
        Assert.notNull(message, (String)"'message' must not be null");
        this.addMessageDocument(new MessageDocument(message));
        return message;
    }

    public Message<?> removeMessage(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)id));
        MessageDocument document = (MessageDocument)this.mongoTemplate.findAndRemove(query, MessageDocument.class, this.collectionName);
        return document != null ? document.getMessage() : null;
    }

    public long getMessageCount() {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").exists(true).and("groupId").exists(false));
        return this.mongoTemplate.getCollection(this.collectionName).count(query.getQueryObject());
    }

    public MessageGroup getMessageGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Query query = ConfigurableMongoDbMessageStore.groupOrderQuery(groupId);
        MessageDocument messageDocument = (MessageDocument)this.mongoTemplate.findOne(query, MessageDocument.class, this.collectionName);
        if (messageDocument != null) {
            long createdTime = messageDocument.getCreatedTime();
            long lastModifiedTime = messageDocument.getLastModifiedTime();
            boolean complete = messageDocument.isComplete();
            int lastReleasedSequence = messageDocument.getLastReleasedSequence();
            MessageGroup messageGroup = this.getMessageGroupFactory().create((MessageGroupStore)this, groupId, createdTime, complete);
            messageGroup.setLastModified(lastModifiedTime);
            messageGroup.setLastReleasedMessageSequenceNumber(lastReleasedSequence);
            return messageGroup;
        }
        return new SimpleMessageGroup(groupId);
    }

    public MessageGroup addMessageToGroup(Object groupId, Message<?> message) {
        this.addMessagesToGroup(groupId, message);
        return this.getMessageGroup(groupId);
    }

    @Override
    public void addMessagesToGroup(Object groupId, Message<?> ... messages) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(messages, (String)"'message' must not be null");
        Query query = ConfigurableMongoDbMessageStore.groupOrderQuery(groupId);
        MessageDocument messageDocument = (MessageDocument)this.mongoTemplate.findOne(query, MessageDocument.class, this.collectionName);
        long createdTime = System.currentTimeMillis();
        int lastReleasedSequence = 0;
        boolean complete = false;
        if (messageDocument != null) {
            createdTime = messageDocument.getCreatedTime();
            lastReleasedSequence = messageDocument.getLastReleasedSequence();
            complete = messageDocument.isComplete();
        }
        for (Message<?> message : messages) {
            MessageDocument document = new MessageDocument(message);
            document.setGroupId(groupId);
            document.setComplete(complete);
            document.setLastReleasedSequence(lastReleasedSequence);
            document.setCreatedTime(createdTime);
            document.setLastModifiedTime(messageDocument == null ? createdTime : System.currentTimeMillis());
            document.setSequence(this.getNextId());
            this.addMessageDocument(document);
        }
    }

    @Override
    @Deprecated
    public MessageGroup removeMessageFromGroup(Object groupId, Message<?> messageToRemove) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(messageToRemove, (String)"'messageToRemove' must not be null");
        Query query = ConfigurableMongoDbMessageStore.groupIdQuery(groupId).addCriteria((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)messageToRemove.getHeaders().getId()));
        this.mongoTemplate.remove(query, this.collectionName);
        this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate());
        return this.getMessageGroup(groupId);
    }

    @Override
    public void removeMessagesFromGroup(Object groupId, Collection<Message<?>> messages) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(messages, (String)"'messageToRemove' must not be null");
        ArrayList<UUID> ids = new ArrayList<UUID>();
        for (Message<?> messageToRemove : messages) {
            ids.add(messageToRemove.getHeaders().getId());
            if (ids.size() < this.getRemoveBatchSize()) continue;
            this.removeMessages(groupId, ids);
            ids.clear();
        }
        if (ids.size() > 0) {
            this.removeMessages(groupId, ids);
        }
        this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate());
    }

    private void removeMessages(Object groupId, Collection<UUID> ids) {
        Query query = ConfigurableMongoDbMessageStore.groupIdQuery(groupId).addCriteria((CriteriaDefinition)Criteria.where((String)"messageId").in(ids.toArray()));
        this.mongoTemplate.remove(query, this.collectionName);
    }

    public void removeMessagesFromGroup(Object groupId, Message<?> ... messages) {
        this.removeMessagesFromGroup(groupId, Arrays.asList(messages));
    }

    public Message<?> pollMessageFromGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Sort sort = new Sort(new String[]{"lastModifiedTime", "sequence"});
        Query query = ConfigurableMongoDbMessageStore.groupIdQuery(groupId).with(sort);
        MessageDocument document = (MessageDocument)this.mongoTemplate.findAndRemove(query, MessageDocument.class, this.collectionName);
        Message<?> message = null;
        if (document != null) {
            message = document.getMessage();
            this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate());
        }
        return message;
    }

    @Override
    public void setLastReleasedSequenceNumberForGroup(Object groupId, int sequenceNumber) {
        this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate().set("lastReleasedSequence", (Object)sequenceNumber));
    }

    @Override
    public void completeGroup(Object groupId) {
        this.updateGroup(groupId, ConfigurableMongoDbMessageStore.lastModifiedUpdate().set("complete", (Object)true));
    }

    @Override
    public Iterator<MessageGroup> iterator() {
        ArrayList<MessageGroup> messageGroups = new ArrayList<MessageGroup>();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"groupId").exists(true));
        List groupIds = this.mongoTemplate.getCollection(this.collectionName).distinct("groupId", query.getQueryObject());
        for (Object groupId : groupIds) {
            messageGroups.add(this.getMessageGroup(groupId));
        }
        return messageGroups.iterator();
    }

    public void registerMessageGroupExpiryCallback(MessageGroupStore.MessageGroupCallback callback) {
        this.expiryCallbacks.add(callback);
    }

    @ManagedOperation
    public int expireMessageGroups(long timeout) {
        int count = 0;
        long threshold = System.currentTimeMillis() - timeout;
        Iterator<MessageGroup> iterator = this.iterator();
        while (iterator.hasNext()) {
            MessageGroup group = iterator.next();
            long timestamp = group.getTimestamp();
            if (this.isTimeoutOnIdle() && group.getLastModified() > 0L) {
                timestamp = group.getLastModified();
            }
            if (timestamp > threshold) continue;
            ++count;
            this.expire(group);
        }
        return count;
    }

    @ManagedAttribute
    public int getMessageCountForAllMessageGroups() {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").exists(true).and("groupId").exists(true));
        long count = this.mongoTemplate.count(query, this.collectionName);
        Assert.isTrue((count <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Message count is out of Integer's range");
        return (int)count;
    }

    @ManagedAttribute
    public int getMessageGroupCount() {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"groupId").exists(true));
        return this.mongoTemplate.getCollection(this.collectionName).distinct("groupId", query.getQueryObject()).size();
    }

    public MessageGroupMetadata getGroupMetadata(Object groupId) {
        throw new UnsupportedOperationException("Not yet implemented for this store");
    }

    @Override
    public Message<?> getOneMessageFromGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Query query = ConfigurableMongoDbMessageStore.groupOrderQuery(groupId);
        MessageDocument messageDocument = (MessageDocument)this.mongoTemplate.findOne(query, MessageDocument.class, this.collectionName);
        if (messageDocument != null) {
            return messageDocument.getMessage();
        }
        return null;
    }

    @Override
    public Collection<Message<?>> getMessagesForGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Query query = ConfigurableMongoDbMessageStore.groupOrderQuery(groupId);
        List documents = this.mongoTemplate.find(query, MessageDocument.class, this.collectionName);
        ArrayList messages = new ArrayList();
        for (MessageDocument document : documents) {
            messages.add(document.getMessage());
        }
        return messages;
    }

    private void expire(MessageGroup group) {
        RuntimeException exception = null;
        for (MessageGroupStore.MessageGroupCallback callback : this.expiryCallbacks) {
            try {
                callback.execute((MessageGroupStore)this, group);
            }
            catch (RuntimeException e) {
                if (exception == null) {
                    exception = e;
                }
                this.logger.error((Object)"Exception in expiry callback", (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void updateGroup(Object groupId, Update update) {
        this.mongoTemplate.updateFirst(ConfigurableMongoDbMessageStore.groupOrderQuery(groupId), update, this.collectionName);
    }

    private static Update lastModifiedUpdate() {
        return Update.update((String)"lastModifiedTime", (Object)System.currentTimeMillis());
    }

    private static Query groupOrderQuery(Object groupId) {
        Sort sort = new Sort(Sort.Direction.DESC, new String[]{"lastModifiedTime", "sequence"});
        return ConfigurableMongoDbMessageStore.groupIdQuery(groupId).with(sort);
    }
}

