/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.inbound;

import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jspecify.annotations.Nullable;
import org.springframework.core.log.LogMessage;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.mail.inbound.MailReceiver;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class MailReceivingMessageSource
extends AbstractMessageSource<Object> {
    private final MailReceiver mailReceiver;
    private final Queue<Object> mailQueue = new ConcurrentLinkedQueue<Object>();

    public MailReceivingMessageSource(MailReceiver mailReceiver) {
        Assert.notNull((Object)mailReceiver, (String)"mailReceiver must not be null");
        this.mailReceiver = mailReceiver;
    }

    public String getComponentType() {
        return "mail:inbound-channel-adapter";
    }

    protected @Nullable Object doReceive() {
        try {
            Object mailMessage = this.mailQueue.poll();
            if (mailMessage == null) {
                Object[] messages = this.mailReceiver.receive();
                if (messages != null) {
                    this.mailQueue.addAll(Arrays.asList(messages));
                }
                mailMessage = this.mailQueue.poll();
            }
            if (mailMessage != null) {
                this.logger.debug((CharSequence)LogMessage.format((String)"received mail message [%s]", (Object)mailMessage));
                return mailMessage;
            }
        }
        catch (Exception e) {
            throw new MessagingException("failure occurred while polling for mail", (Throwable)e);
        }
        return null;
    }
}

