/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.transformer;

import jakarta.mail.Message;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.mail.support.MailUtils;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.integration.transformer.MessageTransformationException;
import org.springframework.integration.transformer.Transformer;

public abstract class AbstractMailMessageTransformer<T>
implements Transformer,
BeanFactoryAware {
    private BeanFactory beanFactory;
    private MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();
    private boolean messageBuilderFactorySet;

    public final void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        if (!this.messageBuilderFactorySet) {
            if (this.beanFactory != null) {
                this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory((BeanFactory)this.beanFactory);
            }
            this.messageBuilderFactorySet = true;
        }
        return this.messageBuilderFactory;
    }

    public org.springframework.messaging.Message<?> transform(org.springframework.messaging.Message<?> message) {
        Object payload = message.getPayload();
        if (!(payload instanceof Message)) {
            throw new MessageTransformationException(message, this.getClass().getSimpleName() + " requires a jakarta.mail.Message payload");
        }
        Message mailMessage = (Message)payload;
        AbstractIntegrationMessageBuilder<T> builder = this.doTransform(mailMessage);
        if (builder == null) {
            throw new MessageTransformationException(message, "failed to transform mail message");
        }
        return builder.copyHeaders(AbstractMailMessageTransformer.extractHeaderMapFromMailMessage(mailMessage)).build();
    }

    protected abstract AbstractIntegrationMessageBuilder<T> doTransform(Message var1);

    private static Map<String, Object> extractHeaderMapFromMailMessage(Message mailMessage) {
        return MailUtils.extractStandardHeaders(mailMessage);
    }
}

