/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.mail.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.mail.MailReceiver;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class MailReceivingMessageSource
implements MessageSource<Message>,
BeanFactoryAware,
BeanNameAware,
NamedComponent {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final MailReceiver mailReceiver;
    private final Queue<Message> mailQueue = new ConcurrentLinkedQueue<Message>();
    private volatile BeanFactory beanFactory;
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();
    private volatile String beanName;

    public MailReceivingMessageSource(MailReceiver mailReceiver) {
        Assert.notNull((Object)mailReceiver, (String)"mailReceiver must not be null");
        this.mailReceiver = mailReceiver;
    }

    public final void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory((BeanFactory)this.beanFactory);
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        return this.messageBuilderFactory;
    }

    public String getComponentName() {
        return this.beanName;
    }

    public String getComponentType() {
        return "mail:inbound-channel-adapter";
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public org.springframework.messaging.Message<Message> receive() {
        try {
            Message mailMessage = this.mailQueue.poll();
            if (mailMessage == null) {
                Message[] messages = this.mailReceiver.receive();
                if (messages != null) {
                    this.mailQueue.addAll(Arrays.asList(messages));
                }
                mailMessage = this.mailQueue.poll();
            }
            if (mailMessage != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("received mail message [" + mailMessage + "]"));
                }
                return this.messageBuilderFactory.withPayload((Object)mailMessage).build();
            }
        }
        catch (Exception e) {
            throw new MessagingException("failure occurred while polling for mail", (Throwable)e);
        }
        return null;
    }
}

