/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import javax.mail.Message;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.integration.MessagingException;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mail.ImapMailReceiver;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;

public class ImapIdleChannelAdapter
extends MessageProducerSupport {
    private final IdleTask idleTask = new IdleTask();
    private volatile boolean shouldReconnectAutomatically = true;
    private volatile Executor taskExecutor = new SimpleAsyncTaskExecutor();
    private final ImapMailReceiver mailReceiver;
    private volatile int reconnectDelay = 10000;
    private volatile ScheduledFuture<?> receivingTask;
    private volatile ScheduledFuture<?> pingTask;
    private volatile long connectionPingInterval = 10000L;

    public ImapIdleChannelAdapter(ImapMailReceiver mailReceiver) {
        Assert.notNull((Object)mailReceiver, (String)"mailReceiver must not be null");
        this.mailReceiver = mailReceiver;
    }

    public void setShouldReconnectAutomatically(boolean shouldReconnectAutomatically) {
        this.shouldReconnectAutomatically = shouldReconnectAutomatically;
    }

    @Deprecated
    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public String getComponentType() {
        return "mail:imap-idle-channel-adapter";
    }

    protected void handleMailMessagingException(javax.mail.MessagingException e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"error occurred in idle task", (Throwable)e);
        }
    }

    protected void doStart() {
        final TaskScheduler scheduler = this.getTaskScheduler();
        Assert.notNull((Object)scheduler, (String)"'taskScheduler' must not be null");
        this.receivingTask = scheduler.schedule(new Runnable(){

            public void run() {
                ImapIdleChannelAdapter.this.taskExecutor.execute(new Runnable(){

                    public void run() {
                        try {
                            ImapIdleChannelAdapter.this.idleTask.run();
                            if (ImapIdleChannelAdapter.this.mailReceiver.getFolder().isOpen()) {
                                if (ImapIdleChannelAdapter.this.logger.isDebugEnabled()) {
                                    ImapIdleChannelAdapter.this.logger.debug((Object)"Task completed successfully. Re-scheduling it again right away");
                                }
                                scheduler.schedule((Runnable)this, new Date());
                            }
                        }
                        catch (IllegalStateException e) {
                            ImapIdleChannelAdapter.this.logger.warn((Object)("Failed to execute IDLE task. Will atempt to resubmit in " + ImapIdleChannelAdapter.this.reconnectDelay + " milliseconds"), (Throwable)e);
                            scheduler.schedule((Runnable)this, new Date(System.currentTimeMillis() + (long)ImapIdleChannelAdapter.this.reconnectDelay));
                        }
                    }
                });
            }
        }, new Date());
        this.pingTask = scheduler.scheduleAtFixedRate(new Runnable(){

            public void run() {
                try {
                    Store store = ImapIdleChannelAdapter.this.mailReceiver.getStore();
                    if (store != null) {
                        store.isConnected();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, this.connectionPingInterval);
    }

    protected void doStop() {
        this.receivingTask.cancel(true);
        this.pingTask.cancel(true);
        try {
            this.mailReceiver.destroy();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failure during the destruction of " + this.mailReceiver, e);
        }
    }

    private class IdleTask
    implements Runnable {
        private IdleTask() {
        }

        public void run() {
            try {
                if (ImapIdleChannelAdapter.this.logger.isDebugEnabled()) {
                    ImapIdleChannelAdapter.this.logger.debug((Object)"waiting for mail");
                }
                ImapIdleChannelAdapter.this.mailReceiver.waitForNewMessages();
                if (ImapIdleChannelAdapter.this.mailReceiver.getFolder().isOpen()) {
                    Message[] mailMessages = ImapIdleChannelAdapter.this.mailReceiver.receive();
                    if (ImapIdleChannelAdapter.this.logger.isDebugEnabled()) {
                        ImapIdleChannelAdapter.this.logger.debug((Object)("received " + mailMessages.length + " mail messages"));
                    }
                    for (Message mailMessage : mailMessages) {
                        final MimeMessage copied = new MimeMessage((MimeMessage)mailMessage);
                        if (ImapIdleChannelAdapter.this.taskExecutor != null) {
                            ImapIdleChannelAdapter.this.taskExecutor.execute(new Runnable(){

                                public void run() {
                                    ImapIdleChannelAdapter.this.sendMessage(MessageBuilder.withPayload((Object)copied).build());
                                }
                            });
                            continue;
                        }
                        ImapIdleChannelAdapter.this.sendMessage(MessageBuilder.withPayload((Object)copied).build());
                    }
                }
            }
            catch (javax.mail.MessagingException e) {
                ImapIdleChannelAdapter.this.handleMailMessagingException(e);
                if (ImapIdleChannelAdapter.this.shouldReconnectAutomatically) {
                    throw new IllegalStateException("Failure in 'idle' task. Will resubmit", e);
                }
                throw new MessagingException("Failure in 'idle' task. Will NOT resubmit", (Throwable)e);
            }
        }
    }
}

