/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.dsl;

import org.jspecify.annotations.Nullable;
import org.springframework.integration.dsl.IntegrationComponentSpec;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.kafka.support.converter.RecordMessageConverter;

public class KafkaTemplateSpec<K, V>
extends IntegrationComponentSpec<KafkaTemplateSpec<K, V>, KafkaTemplate<K, V>> {
    KafkaTemplateSpec(KafkaTemplate<K, V> kafkaTemplate) {
        this.target = kafkaTemplate;
    }

    KafkaTemplateSpec(ProducerFactory<K, V> producerFactory) {
        this.target = new KafkaTemplate(producerFactory);
    }

    public KafkaTemplate<K, V> getTemplate() {
        return (KafkaTemplate)this.target;
    }

    public KafkaTemplateSpec<K, V> id(@Nullable String id) {
        return (KafkaTemplateSpec)super.id(id);
    }

    public KafkaTemplateSpec<K, V> defaultTopic(String defaultTopic) {
        ((KafkaTemplate)this.target).setDefaultTopic(defaultTopic);
        return this;
    }

    public KafkaTemplateSpec<K, V> producerListener(ProducerListener<K, V> producerListener) {
        ((KafkaTemplate)this.target).setProducerListener(producerListener);
        return this;
    }

    public KafkaTemplateSpec<K, V> messageConverter(RecordMessageConverter messageConverter) {
        ((KafkaTemplate)this.target).setMessageConverter(messageConverter);
        return this;
    }
}

