/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.support.parametersource;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.integration.jpa.support.parametersource.ParameterSource;

public class BeanPropertyParameterSource
implements ParameterSource {
    private final BeanWrapper beanWrapper;
    private String @Nullable [] propertyNames;

    public BeanPropertyParameterSource(Object object) {
        this.beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)object);
    }

    @Override
    public boolean hasValue(String paramName) {
        return this.beanWrapper.isReadableProperty(paramName);
    }

    @Override
    public @Nullable Object getValue(String paramName) {
        try {
            return this.beanWrapper.getPropertyValue(paramName);
        }
        catch (NotReadablePropertyException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public String[] getReadablePropertyNames() {
        if (this.propertyNames == null) {
            PropertyDescriptor[] props;
            ArrayList<String> names = new ArrayList<String>();
            for (PropertyDescriptor pd : props = this.beanWrapper.getPropertyDescriptors()) {
                if (!this.beanWrapper.isReadableProperty(pd.getName())) continue;
                names.add(pd.getName());
            }
            this.propertyNames = names.toArray(new String[0]);
        }
        return Arrays.copyOf(this.propertyNames, this.propertyNames.length);
    }
}

