/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.outbound;

import java.util.List;
import org.aopalliance.aop.Advice;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.integration.jpa.core.JpaExecutor;
import org.springframework.integration.jpa.outbound.JpaOutboundGateway;
import org.springframework.integration.jpa.support.OutboundGatewayType;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;

public class JpaOutboundGatewayFactoryBean
extends AbstractFactoryBean<JpaOutboundGateway> {
    private JpaExecutor jpaExecutor;
    private OutboundGatewayType gatewayType = OutboundGatewayType.UPDATING;
    private List<Advice> adviceChain;
    private boolean producesReply = true;
    private MessageChannel outputChannel;
    private int order;
    private long replyTimeout;
    private boolean requiresReply = false;
    private String componentName;

    public void setJpaExecutor(JpaExecutor jpaExecutor) {
        this.jpaExecutor = jpaExecutor;
    }

    public void setGatewayType(OutboundGatewayType gatewayType) {
        this.gatewayType = gatewayType;
    }

    public void setAdviceChain(List<Advice> adviceChain) {
        this.adviceChain = adviceChain;
    }

    public void setProducesReply(boolean producesReply) {
        this.producesReply = producesReply;
    }

    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setReplyTimeout(long replyTimeout) {
        this.replyTimeout = replyTimeout;
    }

    public void setRequiresReply(boolean requiresReply) {
        this.requiresReply = requiresReply;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public Class<?> getObjectType() {
        return MessageHandler.class;
    }

    protected JpaOutboundGateway createInstance() {
        BeanFactory beanFactory;
        JpaOutboundGateway jpaOutboundGateway = new JpaOutboundGateway(this.jpaExecutor);
        jpaOutboundGateway.setGatewayType(this.gatewayType);
        jpaOutboundGateway.setProducesReply(this.producesReply);
        jpaOutboundGateway.setOutputChannel(this.outputChannel);
        jpaOutboundGateway.setOrder(this.order);
        jpaOutboundGateway.setSendTimeout(this.replyTimeout);
        jpaOutboundGateway.setRequiresReply(this.requiresReply);
        jpaOutboundGateway.setComponentName(this.componentName);
        if (this.adviceChain != null) {
            jpaOutboundGateway.setAdviceChain(this.adviceChain);
        }
        if ((beanFactory = this.getBeanFactory()) != null) {
            jpaOutboundGateway.setBeanFactory(beanFactory);
        }
        jpaOutboundGateway.afterPropertiesSet();
        return jpaOutboundGateway;
    }
}

