/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.support.parametersource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionException;
import org.springframework.integration.jpa.support.JpaParameter;
import org.springframework.integration.jpa.support.parametersource.ExpressionEvaluatingParameterSourceUtils;
import org.springframework.integration.jpa.support.parametersource.ParameterSourceFactory;
import org.springframework.integration.jpa.support.parametersource.PositionSupportingParameterSource;
import org.springframework.util.Assert;

public class ExpressionEvaluatingParameterSourceFactory
implements ParameterSourceFactory {
    private static final Log logger = LogFactory.getLog(ExpressionEvaluatingParameterSourceFactory.class);
    private static final Object ERROR = new Object();
    private volatile List<JpaParameter> parameters;
    private final ExpressionEvaluatingParameterSourceUtils.ParameterExpressionEvaluator expressionEvaluator = new ExpressionEvaluatingParameterSourceUtils.ParameterExpressionEvaluator();

    public ExpressionEvaluatingParameterSourceFactory() {
        this(null);
    }

    public ExpressionEvaluatingParameterSourceFactory(BeanFactory beanFactory) {
        this.parameters = new ArrayList<JpaParameter>();
        this.expressionEvaluator.setBeanFactory(beanFactory);
    }

    public void setParameters(List<JpaParameter> parameters) {
        Assert.notEmpty(parameters, (String)"parameters must not be null or empty.");
        for (JpaParameter parameter : parameters) {
            Assert.notNull((Object)parameter, (String)"The provided list (parameters) cannot contain null values.");
        }
        this.parameters = parameters;
        this.expressionEvaluator.getEvaluationContext().setVariable("staticParameters", ExpressionEvaluatingParameterSourceUtils.convertStaticParameters(parameters));
    }

    @Override
    public PositionSupportingParameterSource createParameterSource(Object input) {
        return new ExpressionEvaluatingParameterSource(input, this.parameters, this.expressionEvaluator);
    }

    protected class ExpressionEvaluatingParameterSource
    implements PositionSupportingParameterSource {
        private final Object input;
        private volatile Map<String, Object> values = new HashMap<String, Object>();
        private final List<JpaParameter> parameters;
        private final Map<String, JpaParameter> parametersMap;
        private final ExpressionEvaluatingParameterSourceUtils.ParameterExpressionEvaluator expressionEvaluator;

        protected ExpressionEvaluatingParameterSource(Object input, List<JpaParameter> parameters, ExpressionEvaluatingParameterSourceUtils.ParameterExpressionEvaluator expressionEvaluator) {
            this.input = input;
            this.expressionEvaluator = expressionEvaluator;
            this.parameters = parameters;
            this.parametersMap = new HashMap<String, JpaParameter>(parameters.size());
            for (JpaParameter parameter : parameters) {
                this.parametersMap.put(parameter.getName(), parameter);
            }
            this.values.putAll(ExpressionEvaluatingParameterSourceUtils.convertStaticParameters(parameters));
        }

        @Override
        public Object getValueByPosition(int position) {
            Assert.isTrue((position >= 0 ? 1 : 0) != 0, (String)"The position must be non-negative.");
            if (position <= this.parameters.size()) {
                JpaParameter parameter = this.parameters.get(position);
                if (parameter.getValue() != null) {
                    return parameter.getValue();
                }
                if (parameter.getExpression() != null) {
                    Expression expression = this.input instanceof Collection ? parameter.getProjectionExpression() : parameter.getSpelExpression();
                    Object value = this.expressionEvaluator.evaluateExpression(expression, this.input);
                    if (parameter.getName() != null) {
                        this.values.put(parameter.getName(), value);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Resolved expression " + expression + " to " + value));
                    }
                    return value;
                }
            }
            return null;
        }

        @Override
        public Object getValue(String paramName) {
            if (this.values.containsKey(paramName)) {
                return this.values.get(paramName);
            }
            if (!this.parametersMap.containsKey(paramName)) {
                JpaParameter parameter = new JpaParameter(paramName, null, paramName);
                ExpressionEvaluatingParameterSourceFactory.this.parameters.add(parameter);
                this.parametersMap.put(paramName, parameter);
            }
            JpaParameter jpaParameter = this.parametersMap.get(paramName);
            Expression expression = this.input instanceof Collection ? jpaParameter.getProjectionExpression() : jpaParameter.getSpelExpression();
            Object value = this.expressionEvaluator.evaluateExpression(expression, this.input);
            this.values.put(paramName, value);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resolved expression " + expression + " to " + value));
            }
            return value;
        }

        @Override
        public boolean hasValue(String paramName) {
            try {
                Object value = this.getValue(paramName);
                if (value == ERROR) {
                    return false;
                }
            }
            catch (ExpressionException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Could not evaluate expression", (Throwable)e);
                }
                this.values.put(paramName, ERROR);
                return false;
            }
            return true;
        }
    }
}

