/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.core;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.jpa.core.DefaultJpaOperations;
import org.springframework.integration.jpa.core.JpaOperations;
import org.springframework.integration.jpa.support.JpaParameter;
import org.springframework.integration.jpa.support.PersistMode;
import org.springframework.integration.jpa.support.parametersource.BeanPropertyParameterSourceFactory;
import org.springframework.integration.jpa.support.parametersource.ExpressionEvaluatingParameterSourceFactory;
import org.springframework.integration.jpa.support.parametersource.ParameterSource;
import org.springframework.integration.jpa.support.parametersource.ParameterSourceFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class JpaExecutor
implements InitializingBean,
BeanFactoryAware {
    private final JpaOperations jpaOperations;
    private volatile List<JpaParameter> jpaParameters;
    private volatile Class<?> entityClass;
    private volatile String jpaQuery;
    private volatile String nativeQuery;
    private volatile String namedQuery;
    private volatile Expression maxResultsExpression;
    private volatile Expression firstResultExpression;
    private volatile Expression idExpression;
    private volatile PersistMode persistMode = PersistMode.MERGE;
    private volatile ParameterSourceFactory parameterSourceFactory = null;
    private volatile ParameterSource parameterSource;
    private volatile boolean flush = false;
    private volatile int flushSize = 0;
    private volatile boolean clearOnFlush = false;
    private volatile boolean deleteAfterPoll = false;
    private volatile boolean deleteInBatch = false;
    private volatile boolean expectSingleResult = false;
    private volatile Boolean usePayloadAsParameterSource = null;
    private volatile BeanFactory beanFactory;
    private volatile EvaluationContext evaluationContext;

    public JpaExecutor(EntityManagerFactory entityManagerFactory) {
        Assert.notNull((Object)entityManagerFactory, (String)"entityManagerFactory must not be null.");
        DefaultJpaOperations defaultJpaOperations = new DefaultJpaOperations();
        defaultJpaOperations.setEntityManagerFactory(entityManagerFactory);
        defaultJpaOperations.afterPropertiesSet();
        this.jpaOperations = defaultJpaOperations;
    }

    public JpaExecutor(EntityManager entityManager) {
        Assert.notNull((Object)entityManager, (String)"entityManager must not be null.");
        DefaultJpaOperations defaultJpaOperations = new DefaultJpaOperations();
        defaultJpaOperations.setEntityManager(entityManager);
        defaultJpaOperations.afterPropertiesSet();
        this.jpaOperations = defaultJpaOperations;
    }

    public JpaExecutor(JpaOperations jpaOperations) {
        Assert.notNull((Object)jpaOperations, (String)"jpaOperations must not be null.");
        this.jpaOperations = jpaOperations;
    }

    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        if (!CollectionUtils.isEmpty(this.jpaParameters)) {
            if (this.parameterSourceFactory == null) {
                ExpressionEvaluatingParameterSourceFactory expressionSourceFactory = new ExpressionEvaluatingParameterSourceFactory(this.beanFactory);
                expressionSourceFactory.setParameters(this.jpaParameters);
                this.parameterSourceFactory = expressionSourceFactory;
            } else if (!(this.parameterSourceFactory instanceof ExpressionEvaluatingParameterSourceFactory)) {
                throw new IllegalStateException("You are providing 'JpaParameters'. Was expecting the the provided jpaParameterSourceFactory to be an instance of 'ExpressionEvaluatingJpaParameterSourceFactory', however the provided one is of type '" + this.parameterSourceFactory.getClass().getName() + "'");
            }
            if (this.usePayloadAsParameterSource == null) {
                this.usePayloadAsParameterSource = false;
            }
        } else {
            if (this.parameterSourceFactory == null) {
                this.parameterSourceFactory = new BeanPropertyParameterSourceFactory();
            }
            if (this.usePayloadAsParameterSource == null) {
                this.usePayloadAsParameterSource = true;
            }
        }
        if (this.flushSize > 0) {
            this.flush = true;
        } else if (this.flush) {
            this.flushSize = 1;
        }
        if (this.evaluationContext == null) {
            this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.beanFactory);
        }
    }

    public Object executeOutboundJpaOperation(Message<?> message) {
        Object result;
        ParameterSource parameterSource = null;
        if (this.jpaQuery != null || this.nativeQuery != null || this.namedQuery != null) {
            parameterSource = this.determineParameterSource(message);
        }
        if (this.jpaQuery != null) {
            result = this.jpaOperations.executeUpdate(this.jpaQuery, parameterSource);
        } else if (this.nativeQuery != null) {
            result = this.jpaOperations.executeUpdateWithNativeQuery(this.nativeQuery, parameterSource);
        } else if (this.namedQuery != null) {
            result = this.jpaOperations.executeUpdateWithNamedQuery(this.namedQuery, parameterSource);
        } else if (PersistMode.PERSIST.equals((Object)this.persistMode)) {
            this.jpaOperations.persist(message.getPayload(), this.flushSize, this.clearOnFlush);
            result = message.getPayload();
        } else if (PersistMode.MERGE.equals((Object)this.persistMode)) {
            result = this.jpaOperations.merge(message.getPayload(), this.flushSize, this.clearOnFlush);
        } else if (PersistMode.DELETE.equals((Object)this.persistMode)) {
            this.jpaOperations.delete(message.getPayload());
            if (this.flush) {
                this.jpaOperations.flush();
            }
            result = message.getPayload();
        } else {
            throw new IllegalStateException(String.format("Unsupported PersistMode: '%s'", this.persistMode.name()));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object poll(Message<?> requestMessage) {
        void var2_10;
        if (this.idExpression != null) {
            Object id = this.idExpression.getValue(this.evaluationContext, requestMessage);
            Class<?> entityClass = this.entityClass;
            if (entityClass == null) {
                entityClass = requestMessage.getPayload().getClass();
            }
            Object obj = this.jpaOperations.find(entityClass, id);
        } else {
            List<?> result;
            int maxNumberOfResults = this.evaluateExpressionForNumericResult(requestMessage, this.maxResultsExpression);
            if (requestMessage == null) {
                result = this.doPoll(this.parameterSource, 0, maxNumberOfResults);
            } else {
                int firstResult = 0;
                if (this.firstResultExpression != null) {
                    firstResult = this.getFirstResult(requestMessage);
                }
                ParameterSource parameterSource = this.determineParameterSource(requestMessage);
                result = this.doPoll(parameterSource, firstResult, maxNumberOfResults);
            }
            if (result.isEmpty()) {
                Object var2_7 = null;
            } else if (this.expectSingleResult) {
                if (result.size() != 1) throw new MessagingException(requestMessage, "The Jpa operation returned more than 1 result object but expectSingleResult was 'true'.");
                Object obj = result.iterator().next();
            } else {
                List<?> list = result;
            }
        }
        if (var2_10 == null || !this.deleteAfterPoll) return var2_10;
        if (var2_10 instanceof Iterable) {
            if (this.deleteInBatch) {
                this.jpaOperations.deleteInBatch((Iterable)var2_10);
            } else {
                for (Object entity : (Iterable)var2_10) {
                    this.jpaOperations.delete(entity);
                }
            }
        } else {
            this.jpaOperations.delete(var2_10);
        }
        if (!this.flush) return var2_10;
        this.jpaOperations.flush();
        return var2_10;
    }

    private int getFirstResult(Message<?> requestMessage) {
        return this.evaluateExpressionForNumericResult(requestMessage, this.firstResultExpression);
    }

    private int evaluateExpressionForNumericResult(Message<?> requestMessage, Expression expression) {
        Object evaluationResult;
        int evaluatedResult = 0;
        if (expression != null && (evaluationResult = expression.getValue(this.evaluationContext, requestMessage)) != null) {
            if (evaluationResult instanceof Number) {
                evaluatedResult = ((Number)evaluationResult).intValue();
            } else if (evaluationResult instanceof String) {
                try {
                    evaluatedResult = Integer.parseInt((String)evaluationResult);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Value " + evaluationResult + " passed as cannot be parsed to a number, expected to be numeric");
                }
            } else {
                throw new IllegalArgumentException("Expected the value to be a Number got " + evaluationResult.getClass().getName());
            }
        }
        return evaluatedResult;
    }

    private ParameterSource determineParameterSource(Message<?> requestMessage) {
        ParameterSource parameterSource = this.usePayloadAsParameterSource != false ? this.parameterSourceFactory.createParameterSource(requestMessage.getPayload()) : this.parameterSourceFactory.createParameterSource(requestMessage);
        return parameterSource;
    }

    public Object poll() {
        return this.poll(null);
    }

    protected List<?> doPoll(ParameterSource jpaQLParameterSource, int firstResult, int maxNumberOfResults) {
        List<?> payload = null;
        if (this.jpaQuery != null) {
            payload = this.jpaOperations.getResultListForQuery(this.jpaQuery, jpaQLParameterSource, firstResult, maxNumberOfResults);
        } else if (this.nativeQuery != null) {
            payload = this.jpaOperations.getResultListForNativeQuery(this.nativeQuery, this.entityClass, jpaQLParameterSource, firstResult, maxNumberOfResults);
        } else if (this.namedQuery != null) {
            payload = this.jpaOperations.getResultListForNamedQuery(this.namedQuery, jpaQLParameterSource, firstResult, maxNumberOfResults);
        } else if (this.entityClass != null) {
            payload = this.jpaOperations.getResultListForClass(this.entityClass, firstResult, maxNumberOfResults);
        } else {
            throw new IllegalStateException("For the polling operation, one of the following properties must be specified: query, namedQuery or entityClass.");
        }
        return payload;
    }

    public void setEntityClass(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"entityClass must not be null.");
        this.entityClass = entityClass;
    }

    public void setJpaQuery(String jpaQuery) {
        Assert.isTrue((this.nativeQuery == null && this.namedQuery == null ? 1 : 0) != 0, (String)"You can define only one of the properties 'jpaQuery', 'nativeQuery', 'namedQuery'");
        Assert.hasText((String)jpaQuery, (String)"jpaQuery must neither be null nor empty.");
        this.jpaQuery = jpaQuery;
    }

    public void setNativeQuery(String nativeQuery) {
        Assert.isTrue((this.namedQuery == null && this.jpaQuery == null ? 1 : 0) != 0, (String)"You can define only one of the properties 'jpaQuery', 'nativeQuery', 'namedQuery'");
        Assert.hasText((String)nativeQuery, (String)"nativeQuery must neither be null nor empty.");
        this.nativeQuery = nativeQuery;
    }

    public void setNamedQuery(String namedQuery) {
        Assert.isTrue((this.jpaQuery == null && this.nativeQuery == null ? 1 : 0) != 0, (String)"You can define only one of the properties 'jpaQuery', 'nativeQuery', 'namedQuery'");
        Assert.hasText((String)namedQuery, (String)"namedQuery must neither be null nor empty.");
        this.namedQuery = namedQuery;
    }

    public void setPersistMode(PersistMode persistMode) {
        this.persistMode = persistMode;
    }

    public void setJpaParameters(List<JpaParameter> jpaParameters) {
        this.jpaParameters = jpaParameters;
    }

    public void setUsePayloadAsParameterSource(Boolean usePayloadAsParameterSource) {
        this.usePayloadAsParameterSource = usePayloadAsParameterSource;
    }

    public void setFlush(boolean flush) {
        this.flush = flush;
    }

    public void setFlushSize(int flushSize) {
        Assert.state((flushSize >= 0 ? 1 : 0) != 0, (String)"'flushSize' cannot be less than '0'.");
        this.flushSize = flushSize;
    }

    public void setClearOnFlush(boolean clearOnFlush) {
        this.clearOnFlush = clearOnFlush;
    }

    public void setDeleteInBatch(boolean deleteInBatch) {
        this.deleteInBatch = deleteInBatch;
    }

    public void setDeleteAfterPoll(boolean deleteAfterPoll) {
        this.deleteAfterPoll = deleteAfterPoll;
    }

    public void setParameterSourceFactory(ParameterSourceFactory parameterSourceFactory) {
        Assert.notNull((Object)parameterSourceFactory, (String)"parameterSourceFactory must not be null.");
        this.parameterSourceFactory = parameterSourceFactory;
    }

    public void setParameterSource(ParameterSource parameterSource) {
        Assert.notNull((Object)parameterSource, (String)"parameterSource must not be null.");
        this.parameterSource = parameterSource;
    }

    public void setExpectSingleResult(boolean expectSingleResult) {
        this.expectSingleResult = expectSingleResult;
    }

    public void setFirstResultExpression(Expression firstResultExpression) {
        this.firstResultExpression = firstResultExpression;
    }

    public void setIdExpression(Expression idExpression) {
        this.idExpression = idExpression;
    }

    public void setMaxResultsExpression(Expression maxResultsExpression) {
        Assert.notNull((Object)maxResultsExpression, (String)"maxResultsExpression cannot be null");
        this.maxResultsExpression = maxResultsExpression;
    }

    public void setMaxNumberOfResults(int maxNumberOfResults) {
        this.setMaxResultsExpression((Expression)new LiteralExpression("" + maxNumberOfResults));
    }
}

