/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.config.xml;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jpa.config.xml.JpaParserUtils;
import org.springframework.integration.jpa.inbound.JpaPollingChannelAdapter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JpaInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        BeanDefinition definition;
        BeanDefinitionBuilder jpaPollingChannelAdapterBuilder = BeanDefinitionBuilder.genericBeanDefinition(JpaPollingChannelAdapter.class);
        BeanDefinitionBuilder jpaExecutorBuilder = JpaParserUtils.getJpaExecutorBuilder(element, parserContext);
        String maxNumberOfResults = element.getAttribute("max-number-of-results");
        boolean hasMaxNumberOfResults = StringUtils.hasText((String)maxNumberOfResults);
        String maxResults = element.getAttribute("max-results");
        boolean hasMaxResults = StringUtils.hasText((String)maxResults);
        if (hasMaxNumberOfResults) {
            parserContext.getReaderContext().warning("'max-number-of-results' is deprecated in favor of 'max-results'", (Object)element);
            if (hasMaxResults) {
                parserContext.getReaderContext().error("'max-number-of-results' and 'max-results' are mutually exclusive", (Object)element);
            } else {
                element.setAttribute("max-results", maxNumberOfResults);
            }
        }
        if ((definition = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"max-results", (String)"max-results-expression", (ParserContext)parserContext, (Element)element, (boolean)false)) != null) {
            jpaExecutorBuilder.addPropertyValue("maxResultsExpression", (Object)definition);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)element, (String)"delete-after-poll");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)element, (String)"flush-after-delete", (String)"flush");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)element, (String)"delete-in-batch");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)jpaExecutorBuilder, (Element)element, (String)"expect-single-result");
        AbstractBeanDefinition jpaExecutorBuilderBeanDefinition = jpaExecutorBuilder.getBeanDefinition();
        String channelAdapterId = this.resolveId(element, jpaPollingChannelAdapterBuilder.getRawBeanDefinition(), parserContext);
        String jpaExecutorBeanName = channelAdapterId + ".jpaExecutor";
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)jpaExecutorBuilderBeanDefinition, jpaExecutorBeanName));
        jpaPollingChannelAdapterBuilder.addConstructorArgReference(jpaExecutorBeanName);
        return jpaPollingChannelAdapterBuilder.getBeanDefinition();
    }
}

