/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.monitor;

import org.springframework.integration.monitor.ExponentialMovingAverage;
import org.springframework.integration.monitor.Statistics;

public class ExponentialMovingAverageRate {
    private final ExponentialMovingAverage rates;
    private volatile double weight;
    private volatile double sum;
    private volatile double min;
    private volatile double max;
    private volatile long t0 = System.currentTimeMillis();
    private final double lapse;
    private final double period;

    public ExponentialMovingAverageRate(double period, double lapsePeriod, int window) {
        this.rates = new ExponentialMovingAverage(window);
        this.lapse = lapsePeriod > 0.0 ? 0.001 / lapsePeriod : 0.0;
        this.period = period * 1000.0;
    }

    public synchronized void reset() {
        this.min = 0.0;
        this.max = 0.0;
        this.weight = 0.0;
        this.sum = 0.0;
        this.t0 = System.currentTimeMillis();
        this.rates.reset();
    }

    public synchronized void increment() {
        double value;
        long t = System.currentTimeMillis();
        double d = value = t > this.t0 ? (double)(t - this.t0) / this.period : 0.0;
        if (value > this.max || this.getCount() == 0) {
            this.max = value;
        }
        if (value < this.min || this.getCount() == 0) {
            this.min = value;
        }
        double alpha = Math.exp((double)(this.t0 - t) * this.lapse);
        this.t0 = t;
        this.sum = alpha * this.sum + value;
        this.weight = alpha * this.weight + 1.0;
        this.rates.append(this.sum > 0.0 ? this.weight / this.sum : 0.0);
    }

    public int getCount() {
        return this.rates.getCount();
    }

    public long getCountLong() {
        return this.rates.getCountLong();
    }

    public double getTimeSinceLastMeasurement() {
        return (double)(System.currentTimeMillis() - this.t0) / 1000.0;
    }

    public double getMean() {
        long count = this.rates.getCountLong();
        if (count == 0L) {
            return 0.0;
        }
        long t = System.currentTimeMillis();
        double value = t > this.t0 ? (double)(t - this.t0) / this.period : 0.0;
        return (double)count / ((double)count / this.rates.getMean() + value);
    }

    public double getStandardDeviation() {
        return this.rates.getStandardDeviation();
    }

    public double getMax() {
        return this.min > 0.0 ? 1.0 / this.min : 0.0;
    }

    public double getMin() {
        return this.max > 0.0 ? 1.0 / this.max : 0.0;
    }

    public Statistics getStatistics() {
        return new Statistics(this.getCount(), this.min, this.max, this.getMean(), this.getStandardDeviation());
    }

    public String toString() {
        return String.format("[%s, timeSinceLast=%f]", this.getStatistics(), this.getTimeSinceLastMeasurement());
    }
}

