/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.dsl;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.springframework.integration.jms.dsl.JmsDefaultListenerContainerSpec;
import org.springframework.integration.jms.dsl.JmsInboundChannelAdapterSpec;
import org.springframework.integration.jms.dsl.JmsInboundGatewaySpec;
import org.springframework.integration.jms.dsl.JmsListenerContainerSpec;
import org.springframework.integration.jms.dsl.JmsMessageChannelSpec;
import org.springframework.integration.jms.dsl.JmsMessageDrivenChannelAdapterSpec;
import org.springframework.integration.jms.dsl.JmsOutboundChannelAdapterSpec;
import org.springframework.integration.jms.dsl.JmsOutboundGatewaySpec;
import org.springframework.integration.jms.dsl.JmsPollableMessageChannelSpec;
import org.springframework.integration.jms.dsl.JmsPublishSubscribeMessageChannelSpec;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public final class Jms {
    public static <S extends JmsPollableMessageChannelSpec<S>> JmsPollableMessageChannelSpec<S> pollableChannel(ConnectionFactory connectionFactory) {
        return Jms.pollableChannel(null, connectionFactory);
    }

    public static <S extends JmsPollableMessageChannelSpec<S>> JmsPollableMessageChannelSpec<S> pollableChannel(String id, ConnectionFactory connectionFactory) {
        return new JmsPollableMessageChannelSpec(connectionFactory).id(id);
    }

    public static <S extends JmsMessageChannelSpec<S>> JmsMessageChannelSpec<S> channel(ConnectionFactory connectionFactory) {
        return Jms.channel(null, connectionFactory);
    }

    public static <S extends JmsMessageChannelSpec<S>> JmsMessageChannelSpec<S> channel(String id, ConnectionFactory connectionFactory) {
        return (JmsMessageChannelSpec)new JmsMessageChannelSpec(connectionFactory).id(id);
    }

    public static JmsPublishSubscribeMessageChannelSpec publishSubscribeChannel(ConnectionFactory connectionFactory) {
        return Jms.publishSubscribeChannel(null, connectionFactory);
    }

    public static JmsPublishSubscribeMessageChannelSpec publishSubscribeChannel(String id, ConnectionFactory connectionFactory) {
        return (JmsPublishSubscribeMessageChannelSpec)new JmsPublishSubscribeMessageChannelSpec(connectionFactory).id(id);
    }

    public static <S extends JmsOutboundChannelAdapterSpec<S>> JmsOutboundChannelAdapterSpec<S> outboundAdapter(JmsTemplate jmsTemplate) {
        return new JmsOutboundChannelAdapterSpec(jmsTemplate);
    }

    public static JmsOutboundChannelAdapterSpec.JmsOutboundChannelSpecTemplateAware outboundAdapter(ConnectionFactory connectionFactory) {
        return new JmsOutboundChannelAdapterSpec.JmsOutboundChannelSpecTemplateAware(connectionFactory);
    }

    public static <S extends JmsInboundChannelAdapterSpec<S>> JmsInboundChannelAdapterSpec<S> inboundAdapter(JmsTemplate jmsTemplate) {
        return new JmsInboundChannelAdapterSpec(jmsTemplate);
    }

    public static JmsInboundChannelAdapterSpec.JmsInboundChannelSpecTemplateAware inboundAdapter(ConnectionFactory connectionFactory) {
        return new JmsInboundChannelAdapterSpec.JmsInboundChannelSpecTemplateAware(connectionFactory);
    }

    public static JmsOutboundGatewaySpec outboundGateway(ConnectionFactory connectionFactory) {
        return new JmsOutboundGatewaySpec(connectionFactory);
    }

    public static <S extends JmsInboundGatewaySpec<S>> JmsInboundGatewaySpec<S> inboundGateway(AbstractMessageListenerContainer listenerContainer) {
        return new JmsInboundGatewaySpec(listenerContainer);
    }

    public static JmsInboundGatewaySpec.JmsInboundGatewayListenerContainerSpec<JmsDefaultListenerContainerSpec, DefaultMessageListenerContainer> inboundGateway(ConnectionFactory connectionFactory) {
        return Jms.inboundGateway(connectionFactory, DefaultMessageListenerContainer.class);
    }

    public static <S extends JmsListenerContainerSpec<S, C>, C extends AbstractMessageListenerContainer> JmsInboundGatewaySpec.JmsInboundGatewayListenerContainerSpec<S, C> inboundGateway(ConnectionFactory connectionFactory, Class<C> containerClass) {
        try {
            JmsListenerContainerSpec spec = (JmsListenerContainerSpec)((Object)new JmsListenerContainerSpec(containerClass).connectionFactory(connectionFactory));
            return new JmsInboundGatewaySpec.JmsInboundGatewayListenerContainerSpec(spec);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <S extends JmsMessageDrivenChannelAdapterSpec<S>> JmsMessageDrivenChannelAdapterSpec<S> messageDrivenChannelAdapter(AbstractMessageListenerContainer listenerContainer) {
        return new JmsMessageDrivenChannelAdapterSpec(listenerContainer);
    }

    public static JmsMessageDrivenChannelAdapterSpec.JmsMessageDrivenChannelAdapterListenerContainerSpec<JmsDefaultListenerContainerSpec, DefaultMessageListenerContainer> messageDrivenChannelAdapter(ConnectionFactory connectionFactory) {
        try {
            return new JmsMessageDrivenChannelAdapterSpec.JmsMessageDrivenChannelAdapterListenerContainerSpec((JmsListenerContainerSpec)((Object)new JmsDefaultListenerContainerSpec().connectionFactory(connectionFactory)));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <S extends JmsListenerContainerSpec<S, C>, C extends AbstractMessageListenerContainer> JmsMessageDrivenChannelAdapterSpec.JmsMessageDrivenChannelAdapterListenerContainerSpec<S, C> messageDrivenChannelAdapter(ConnectionFactory connectionFactory, Class<C> containerClass) {
        try {
            JmsListenerContainerSpec spec = (JmsListenerContainerSpec)((Object)new JmsListenerContainerSpec(containerClass).connectionFactory(connectionFactory));
            return new JmsMessageDrivenChannelAdapterSpec.JmsMessageDrivenChannelAdapterListenerContainerSpec(spec);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static JmsDefaultListenerContainerSpec container(ConnectionFactory connectionFactory, Destination destination) {
        try {
            return (JmsDefaultListenerContainerSpec)((Object)((JmsDefaultListenerContainerSpec)((Object)new JmsDefaultListenerContainerSpec().connectionFactory(connectionFactory))).destination(destination));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static JmsDefaultListenerContainerSpec container(ConnectionFactory connectionFactory, String destinationName) {
        try {
            return (JmsDefaultListenerContainerSpec)((Object)((JmsDefaultListenerContainerSpec)((Object)new JmsDefaultListenerContainerSpec().connectionFactory(connectionFactory))).destination(destinationName));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Jms() {
    }
}

