/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.config;

import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jms.config.JmsAdapterParserUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JmsInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected String parseSource(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.jms.JmsDestinationPollingSource");
        String jmsTemplate = element.getAttribute("jms-template");
        String destination = element.getAttribute("destination");
        String destinationName = element.getAttribute("destination-name");
        String headerMapper = element.getAttribute("header-mapper");
        if (StringUtils.hasText((String)jmsTemplate)) {
            if (element.hasAttribute("connection-factory") || element.hasAttribute("destination-name") || element.hasAttribute("destination")) {
                throw new BeanCreationException("When providing 'jms-template', none of 'connection-factory', 'destination', or 'destination-name' should be provided.");
            }
            builder.addConstructorArgReference(jmsTemplate);
        } else if (StringUtils.hasText((String)destination) || StringUtils.hasText((String)destinationName)) {
            builder.addConstructorArgReference(JmsAdapterParserUtils.determineConnectionFactoryBeanName(element, parserContext));
            if (StringUtils.hasText((String)destination)) {
                builder.addConstructorArgReference(destination);
            } else if (StringUtils.hasText((String)destinationName)) {
                builder.addConstructorArgValue((Object)destinationName);
            }
        } else {
            throw new BeanCreationException("either a 'jms-template' or one of 'destination' or 'destination-name' attributes must be provided for a polling JMS adapter");
        }
        if (StringUtils.hasText((String)headerMapper)) {
            builder.addPropertyReference("headerMapper", headerMapper);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-payload");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"destination-resolver");
        return BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
    }
}

