/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.springframework.integration.core.Message;
import org.springframework.integration.jms.AbstractJmsTemplateBasedAdapter;
import org.springframework.integration.jms.HeaderMappingMessageConverter;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.message.GenericMessage;
import org.springframework.integration.message.MessageSource;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.MessageConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsDestinationPollingSource
extends AbstractJmsTemplateBasedAdapter
implements MessageSource<Object> {
    private volatile boolean extractPayload = true;

    public JmsDestinationPollingSource(JmsTemplate jmsTemplate) {
        super(jmsTemplate);
    }

    public JmsDestinationPollingSource(ConnectionFactory connectionFactory, Destination destination) {
        super(connectionFactory, destination);
    }

    public JmsDestinationPollingSource(ConnectionFactory connectionFactory, String destinationName) {
        super(connectionFactory, destinationName);
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public Message<Object> receive() {
        Object receivedObject = this.getJmsTemplate().receiveAndConvert();
        if (receivedObject == null) {
            return null;
        }
        if (receivedObject instanceof Message) {
            return (Message)receivedObject;
        }
        return new GenericMessage(receivedObject);
    }

    @Override
    protected void configureMessageConverter(JmsTemplate jmsTemplate, JmsHeaderMapper headerMapper) {
        MessageConverter converter = jmsTemplate.getMessageConverter();
        if (converter == null || !(converter instanceof HeaderMappingMessageConverter)) {
            HeaderMappingMessageConverter hmmc = new HeaderMappingMessageConverter(converter, headerMapper);
            hmmc.setExtractJmsMessageBody(this.extractPayload);
            jmsTemplate.setMessageConverter((MessageConverter)hmmc);
        }
    }
}

