/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.store.channel;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.springframework.integration.support.json.JsonObjectMapper;
import org.springframework.integration.support.json.JsonObjectMapperProvider;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class JsonMessageRowMapper
implements RowMapper<Message<?>> {
    private final JsonObjectMapper<?, ?> jsonObjectMapper;

    public JsonMessageRowMapper(String ... trustedPackages) {
        this(JsonObjectMapperProvider.newMessagingAwareInstance((String[])trustedPackages));
    }

    public JsonMessageRowMapper(JsonObjectMapper<?, ?> jsonObjectMapper) {
        Assert.notNull(jsonObjectMapper, (String)"'jsonObjectMapper' must not be null");
        this.jsonObjectMapper = jsonObjectMapper;
    }

    public Message<?> mapRow(ResultSet rs, int rowNum) throws SQLException {
        try {
            String json = rs.getString("MESSAGE_CONTENT");
            if (json == null) {
                throw new SQLException("MESSAGE_CONTENT column is null at row " + rowNum);
            }
            return Objects.requireNonNull((Message)this.jsonObjectMapper.fromJson((Object)json, Message.class));
        }
        catch (IOException ex) {
            throw new SQLException("Failed to deserialize message from JSON at row " + rowNum + ". Ensure the JSON and the configured JsonObjectMapper use compatible type handling.", ex);
        }
    }
}

