/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.dsl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.IntegrationComponentSpec;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.integration.jdbc.StoredProcExecutor;
import org.springframework.integration.jdbc.storedproc.ProcedureParameter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameter;

public class StoredProcExecutorSpec
extends IntegrationComponentSpec<StoredProcExecutorSpec, StoredProcExecutor> {
    private final List<ProcedureParameter> procedureParameters = new ArrayList<ProcedureParameter>();
    private final List<SqlParameter> sqlParameters = new ArrayList<SqlParameter>();
    private final Map<String, RowMapper<?>> returningResultSetRowMappers = new HashMap();

    protected StoredProcExecutorSpec(DataSource dataSource) {
        this.target = new StoredProcExecutor(dataSource);
        ((StoredProcExecutor)this.target).setReturningResultSetRowMappers(this.returningResultSetRowMappers);
    }

    public StoredProcExecutorSpec ignoreColumnMetaData(boolean ignoreColumnMetaData) {
        ((StoredProcExecutor)this.target).setIgnoreColumnMetaData(ignoreColumnMetaData);
        return this;
    }

    public StoredProcExecutorSpec procedureParameter(ProcedureParameter procedureParameter) {
        this.procedureParameters.add(procedureParameter);
        ((StoredProcExecutor)this.target).setProcedureParameters(this.procedureParameters);
        return this;
    }

    public StoredProcExecutorSpec procedureParameters(List<ProcedureParameter> procedureParameters) {
        ((StoredProcExecutor)this.target).setProcedureParameters(procedureParameters);
        return this;
    }

    public StoredProcExecutorSpec sqlParameter(SqlParameter sqlParameter) {
        this.sqlParameters.add(sqlParameter);
        ((StoredProcExecutor)this.target).setSqlParameters(this.sqlParameters);
        return this;
    }

    public StoredProcExecutorSpec sqlParameters(List<SqlParameter> sqlParameters) {
        ((StoredProcExecutor)this.target).setSqlParameters(sqlParameters);
        return this;
    }

    public StoredProcExecutorSpec sqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        ((StoredProcExecutor)this.target).setSqlParameterSourceFactory(sqlParameterSourceFactory);
        return this;
    }

    public StoredProcExecutorSpec storedProcedureName(String storedProcedureName) {
        ((StoredProcExecutor)this.target).setStoredProcedureName(storedProcedureName);
        return this;
    }

    public StoredProcExecutorSpec storedProcedureNameExpression(Expression storedProcedureNameExpression) {
        ((StoredProcExecutor)this.target).setStoredProcedureNameExpression(storedProcedureNameExpression);
        return this;
    }

    public StoredProcExecutorSpec usePayloadAsParameterSource(boolean usePayloadAsParameterSource) {
        ((StoredProcExecutor)this.target).setUsePayloadAsParameterSource(usePayloadAsParameterSource);
        return this;
    }

    public StoredProcExecutorSpec isFunction(boolean isFunction) {
        ((StoredProcExecutor)this.target).setIsFunction(isFunction);
        return this;
    }

    public StoredProcExecutorSpec returnValueRequired(boolean returnValueRequired) {
        ((StoredProcExecutor)this.target).setReturnValueRequired(returnValueRequired);
        return this;
    }

    public StoredProcExecutorSpec skipUndeclaredResults(boolean skipUndeclaredResults) {
        ((StoredProcExecutor)this.target).setSkipUndeclaredResults(skipUndeclaredResults);
        return this;
    }

    public StoredProcExecutorSpec returningResultSetRowMapper(String returningResultName, RowMapper<?> rowMapper) {
        this.returningResultSetRowMappers.put(returningResultName, rowMapper);
        return this;
    }

    public StoredProcExecutorSpec returningResultSetRowMappers(Map<String, RowMapper<?>> returningResultSetRowMappers) {
        ((StoredProcExecutor)this.target).setReturningResultSetRowMappers(returningResultSetRowMappers);
        return this;
    }

    public StoredProcExecutorSpec jdbcCallOperationsCacheSize(int jdbcCallOperationsCacheSize) {
        ((StoredProcExecutor)this.target).setJdbcCallOperationsCacheSize(jdbcCallOperationsCacheSize);
        return this;
    }
}

