/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.config;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jdbc.StoredProcExecutor;
import org.springframework.integration.jdbc.config.JdbcTypesEnum;
import org.springframework.integration.jdbc.storedproc.ProcedureParameter;
import org.springframework.jdbc.core.SqlInOutParameter;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class StoredProcParserUtils {
    private static final Log LOGGER = LogFactory.getLog(StoredProcParserUtils.class);

    private StoredProcParserUtils() {
        throw new AssertionError();
    }

    public static ManagedList<BeanDefinition> getSqlParameterDefinitionBeanDefinitions(Element storedProcComponent, ParserContext parserContext) {
        List sqlParameterDefinitionChildElements = DomUtils.getChildElementsByTagName((Element)storedProcComponent, (String)"sql-parameter-definition");
        ManagedList sqlParameterList = new ManagedList();
        for (Element childElement : sqlParameterDefinitionChildElements) {
            BeanDefinitionBuilder parameterBuilder = StoredProcParserUtils.parseSqlParameter(storedProcComponent, parserContext, childElement);
            sqlParameterList.add((Object)parameterBuilder.getBeanDefinition());
        }
        return sqlParameterList;
    }

    private static BeanDefinitionBuilder parseSqlParameter(Element storedProcComponent, ParserContext parserContext, Element childElement) {
        String name = childElement.getAttribute("name");
        String sqlType = childElement.getAttribute("type");
        String direction = childElement.getAttribute("direction");
        String scale = childElement.getAttribute("scale");
        String typeName = childElement.getAttribute("type-name");
        String returnType = childElement.getAttribute("return-type");
        StoredProcParserUtils.validateParameterAttributes(storedProcComponent, parserContext, scale, typeName, returnType);
        BeanDefinitionBuilder parameterBuilder = StoredProcParserUtils.createParameterBeanDefinitionBuilder(storedProcComponent, parserContext, direction, returnType);
        if (StringUtils.hasText((String)name)) {
            parameterBuilder.addConstructorArgValue((Object)name);
        } else {
            parserContext.getReaderContext().error("The 'name' attribute must be set for the Sql parameter element.", (Object)storedProcComponent);
        }
        if (StringUtils.hasText((String)sqlType)) {
            JdbcTypesEnum jdbcTypeEnum = JdbcTypesEnum.convertToJdbcTypesEnum(sqlType);
            if (jdbcTypeEnum != null) {
                parameterBuilder.addConstructorArgValue((Object)jdbcTypeEnum.getCode());
            } else {
                parameterBuilder.addConstructorArgValue((Object)sqlType);
            }
        } else {
            parameterBuilder.addConstructorArgValue((Object)12);
        }
        if (StringUtils.hasText((String)typeName)) {
            parameterBuilder.addConstructorArgValue((Object)typeName);
        } else if (StringUtils.hasText((String)scale)) {
            parameterBuilder.addConstructorArgValue((Object)new TypedStringValue(scale, Integer.class));
        } else {
            parameterBuilder.addConstructorArgValue(null);
        }
        if (StringUtils.hasText((String)returnType)) {
            parameterBuilder.addConstructorArgReference(returnType);
        }
        return parameterBuilder;
    }

    private static void validateParameterAttributes(Element storedProcComponent, ParserContext parserContext, String scale, String typeName, String returnType) {
        if (StringUtils.hasText((String)typeName) && StringUtils.hasText((String)scale)) {
            parserContext.getReaderContext().error("'type-name' and 'scale' attributes are mutually exclusive for 'sql-parameter-definition' element.", (Object)storedProcComponent);
        }
        if (StringUtils.hasText((String)returnType) && StringUtils.hasText((String)scale)) {
            parserContext.getReaderContext().error("'returnType' and 'scale' attributes are mutually exclusive for 'sql-parameter-definition' element.", (Object)storedProcComponent);
        }
    }

    @NotNull
    private static BeanDefinitionBuilder createParameterBeanDefinitionBuilder(Element storedProcComponent, ParserContext parserContext, String direction, String returnType) {
        BeanDefinitionBuilder parameterBuilder;
        if ("OUT".equalsIgnoreCase(direction)) {
            parameterBuilder = BeanDefinitionBuilder.genericBeanDefinition(SqlOutParameter.class);
        } else if ("INOUT".equalsIgnoreCase(direction)) {
            parameterBuilder = BeanDefinitionBuilder.genericBeanDefinition(SqlInOutParameter.class);
        } else {
            parameterBuilder = BeanDefinitionBuilder.genericBeanDefinition(SqlParameter.class);
            if (StringUtils.hasText((String)returnType)) {
                parserContext.getReaderContext().error("'return-type' attribute can't be provided for IN 'sql-parameter-definition' element.", (Object)storedProcComponent);
            }
        }
        return parameterBuilder;
    }

    public static ManagedList<BeanDefinition> getProcedureParameterBeanDefinitions(Element storedProcComponent, ParserContext parserContext) {
        ManagedList procedureParameterList = new ManagedList();
        List parameterChildElements = DomUtils.getChildElementsByTagName((Element)storedProcComponent, (String)"parameter");
        for (Element childElement : parameterChildElements) {
            BeanDefinitionBuilder parameterBuilder = BeanDefinitionBuilder.genericBeanDefinition(ProcedureParameter.class);
            String name = childElement.getAttribute("name");
            String expression = childElement.getAttribute("expression");
            String value = childElement.getAttribute("value");
            String type = childElement.getAttribute("type");
            if (StringUtils.hasText((String)name)) {
                parameterBuilder.addPropertyValue("name", (Object)name);
            }
            if (StringUtils.hasText((String)expression)) {
                parameterBuilder.addPropertyValue("expression", (Object)expression);
            }
            if (StringUtils.hasText((String)value)) {
                if (!StringUtils.hasText((String)type)) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)String.format("Type attribute not set for Store Procedure parameter '%s'. Defaulting to 'java.lang.String'.", value));
                    }
                    parameterBuilder.addPropertyValue("value", (Object)new TypedStringValue(value, String.class));
                } else {
                    parameterBuilder.addPropertyValue("value", (Object)new TypedStringValue(value, type));
                }
            }
            procedureParameterList.add((Object)parameterBuilder.getBeanDefinition());
        }
        return procedureParameterList;
    }

    public static ManagedMap<String, BeanMetadataElement> getReturningResultsetBeanDefinitions(Element storedProcComponent, ParserContext parserContext) {
        List returningResultsetChildElements = DomUtils.getChildElementsByTagName((Element)storedProcComponent, (String)"returning-resultset");
        ManagedMap returningResultsetMap = new ManagedMap();
        for (Element childElement : returningResultsetChildElements) {
            RuntimeBeanReference rowMapperBeanDefinition;
            String name = childElement.getAttribute("name");
            String rowMapperAsString = childElement.getAttribute("row-mapper");
            try {
                ClassUtils.forName((String)rowMapperAsString, (ClassLoader)parserContext.getReaderContext().getBeanClassLoader());
                rowMapperBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition((String)rowMapperAsString).getBeanDefinition();
            }
            catch (ClassNotFoundException e) {
                rowMapperBeanDefinition = new RuntimeBeanReference(rowMapperAsString);
            }
            returningResultsetMap.put((Object)name, (Object)rowMapperBeanDefinition);
        }
        return returningResultsetMap;
    }

    public static BeanDefinitionBuilder getStoredProcExecutorBuilder(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder expressionBuilder;
        Assert.notNull((Object)element, (String)"The provided element must not be Null.");
        Assert.notNull((Object)parserContext, (String)"The provided parserContext must not be Null.");
        String dataSourceRef = element.getAttribute("data-source");
        BeanDefinitionBuilder storedProcExecutorBuilder = BeanDefinitionBuilder.genericBeanDefinition(StoredProcExecutor.class);
        storedProcExecutorBuilder.addConstructorArgReference(dataSourceRef);
        String storedProcedureName = element.getAttribute("stored-procedure-name");
        String storedProcedureNameExpression = element.getAttribute("stored-procedure-name-expression");
        boolean hasStoredProcedureName = StringUtils.hasText((String)storedProcedureName);
        boolean hasStoredProcedureNameExpression = StringUtils.hasText((String)storedProcedureNameExpression);
        if (hasStoredProcedureName == hasStoredProcedureNameExpression) {
            parserContext.getReaderContext().error("Exactly one of 'stored-procedure-name' or 'stored-procedure-name-expression' is required", (Object)element);
        }
        if (hasStoredProcedureNameExpression) {
            expressionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class);
            expressionBuilder.addConstructorArgValue((Object)storedProcedureNameExpression);
        } else {
            expressionBuilder = BeanDefinitionBuilder.genericBeanDefinition(LiteralExpression.class);
            expressionBuilder.addConstructorArgValue((Object)storedProcedureName);
        }
        storedProcExecutorBuilder.addPropertyValue("storedProcedureNameExpression", (Object)expressionBuilder.getBeanDefinition());
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)storedProcExecutorBuilder, (Element)element, (String)"ignore-column-meta-data");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)storedProcExecutorBuilder, (Element)element, (String)"jdbc-call-operations-cache-size");
        ManagedList<BeanDefinition> procedureParameterList = StoredProcParserUtils.getProcedureParameterBeanDefinitions(element, parserContext);
        ManagedList<BeanDefinition> sqlParameterDefinitionList = StoredProcParserUtils.getSqlParameterDefinitionBeanDefinitions(element, parserContext);
        if (!procedureParameterList.isEmpty()) {
            storedProcExecutorBuilder.addPropertyValue("procedureParameters", procedureParameterList);
        }
        if (!sqlParameterDefinitionList.isEmpty()) {
            storedProcExecutorBuilder.addPropertyValue("sqlParameters", sqlParameterDefinitionList);
        }
        return storedProcExecutorBuilder;
    }
}

