/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.Map;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.jdbc.StoredProcExecutor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class StoredProcPollingChannelAdapter
extends IntegrationObjectSupport
implements MessageSource<Object> {
    private final StoredProcExecutor executor;
    private volatile boolean expectSingleResult = false;

    public StoredProcPollingChannelAdapter(StoredProcExecutor storedProcExecutor) {
        Assert.notNull((Object)storedProcExecutor, (String)"storedProcExecutor must not be null.");
        this.executor = storedProcExecutor;
    }

    public Message<Object> receive() {
        Object payload = this.poll();
        if (payload == null) {
            return null;
        }
        return this.getMessageBuilderFactory().withPayload(payload).build();
    }

    private Object poll() {
        Map<String, Object> payload;
        Map<String, ?> resultMap = this.doPoll();
        if (resultMap.isEmpty()) {
            payload = null;
        } else if (this.expectSingleResult && resultMap.size() == 1) {
            payload = resultMap.values().iterator().next();
        } else {
            if (this.expectSingleResult && resultMap.size() > 1) {
                throw new MessagingException("Stored Procedure/Function call returned more than 1 result object and expectSingleResult was 'true'. ");
            }
            payload = resultMap;
        }
        return payload;
    }

    protected Map<String, ?> doPoll() {
        return this.executor.executeStoredProcedure();
    }

    public String getComponentType() {
        return "stored-proc:inbound-channel-adapter";
    }

    public void setExpectSingleResult(boolean expectSingleResult) {
        this.expectSingleResult = expectSingleResult;
    }
}

