/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jdbc.JdbcMessageStore;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JdbcMessageStoreParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JdbcMessageStore.class);
        String dataSourceRef = element.getAttribute("data-source");
        String simpleJdbcOperationsRef = element.getAttribute("jdbc-operations");
        boolean refToDataSourceSet = StringUtils.hasText((String)dataSourceRef);
        boolean refToSimpleJdbcOperationsSet = StringUtils.hasText((String)simpleJdbcOperationsRef);
        if (refToDataSourceSet && refToSimpleJdbcOperationsSet || !refToDataSourceSet && !refToSimpleJdbcOperationsSet) {
            parserContext.getReaderContext().error("Exactly one of the attributes data-source or simple-jdbc-operations should be set for the JDBC message-store", source);
        }
        if (refToDataSourceSet) {
            builder.addConstructorArgReference(dataSourceRef);
        } else {
            builder.addConstructorArgReference(simpleJdbcOperationsRef);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"lob-handler");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"serializer");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"deserializer");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"table-prefix", (String)"tablePrefix");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"region", (String)"region");
        return builder.getBeanDefinition();
    }
}

