/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.support;

import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.TypedValue;
import org.springframework.expression.common.ExpressionUtils;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.dsl.support.Function;

public class FunctionExpression<S>
implements Expression {
    private final Function<S, ?> function;
    private final EvaluationContext defaultContext = new StandardEvaluationContext();
    private final EvaluationException readOnlyException;

    public FunctionExpression(Function<S, ?> function) {
        this.function = function;
        this.readOnlyException = new EvaluationException(this.getExpressionString(), "FunctionExpression is a 'read only' Expression implementation");
    }

    public Object getValue() throws EvaluationException {
        return this.function.apply(null);
    }

    public Object getValue(Object rootObject) throws EvaluationException {
        return this.function.apply(rootObject);
    }

    public <T> T getValue(Class<T> desiredResultType) throws EvaluationException {
        return this.getValue(this.defaultContext, desiredResultType);
    }

    public <T> T getValue(Object rootObject, Class<T> desiredResultType) throws EvaluationException {
        return this.getValue(this.defaultContext, rootObject, desiredResultType);
    }

    public Object getValue(EvaluationContext context) throws EvaluationException {
        return this.getValue();
    }

    public Object getValue(EvaluationContext context, Object rootObject) throws EvaluationException {
        return this.getValue(rootObject);
    }

    public <T> T getValue(EvaluationContext context, Class<T> desiredResultType) throws EvaluationException {
        return (T)ExpressionUtils.convertTypedValue((EvaluationContext)context, (TypedValue)new TypedValue(this.getValue()), desiredResultType);
    }

    public <T> T getValue(EvaluationContext context, Object rootObject, Class<T> desiredResultType) throws EvaluationException {
        return (T)ExpressionUtils.convertTypedValue((EvaluationContext)context, (TypedValue)new TypedValue(this.getValue(rootObject)), desiredResultType);
    }

    public Class<?> getValueType() throws EvaluationException {
        throw this.readOnlyException;
    }

    public Class<?> getValueType(Object rootObject) throws EvaluationException {
        throw this.readOnlyException;
    }

    public Class<?> getValueType(EvaluationContext context) throws EvaluationException {
        throw this.readOnlyException;
    }

    public Class<?> getValueType(EvaluationContext context, Object rootObject) throws EvaluationException {
        throw this.readOnlyException;
    }

    public TypeDescriptor getValueTypeDescriptor() throws EvaluationException {
        throw this.readOnlyException;
    }

    public TypeDescriptor getValueTypeDescriptor(Object rootObject) throws EvaluationException {
        throw this.readOnlyException;
    }

    public TypeDescriptor getValueTypeDescriptor(EvaluationContext context) throws EvaluationException {
        throw this.readOnlyException;
    }

    public TypeDescriptor getValueTypeDescriptor(EvaluationContext context, Object rootObject) throws EvaluationException {
        throw this.readOnlyException;
    }

    public void setValue(EvaluationContext context, Object value) throws EvaluationException {
        throw this.readOnlyException;
    }

    public void setValue(Object rootObject, Object value) throws EvaluationException {
        throw this.readOnlyException;
    }

    public void setValue(EvaluationContext context, Object rootObject, Object value) throws EvaluationException {
        throw this.readOnlyException;
    }

    public boolean isWritable(EvaluationContext context) throws EvaluationException {
        return false;
    }

    public boolean isWritable(EvaluationContext context, Object rootObject) throws EvaluationException {
        return false;
    }

    public boolean isWritable(Object rootObject) throws EvaluationException {
        return false;
    }

    public String getExpressionString() {
        return this.function.toString();
    }
}

