/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.io.File;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.integration.dsl.amqp.Amqp;
import org.springframework.integration.dsl.amqp.AmqpBaseInboundChannelAdapterSpec;
import org.springframework.integration.dsl.amqp.AmqpInboundChannelAdapterSpec;
import org.springframework.integration.dsl.file.Files;
import org.springframework.integration.dsl.file.TailAdapterSpec;
import org.springframework.integration.dsl.jms.Jms;
import org.springframework.integration.dsl.jms.JmsMessageDrivenChannelAdapterSpec;
import org.springframework.integration.dsl.mail.ImapIdleChannelAdapterSpec;
import org.springframework.integration.dsl.mail.Mail;
import org.springframework.jms.listener.AbstractMessageListenerContainer;

public class MessageProducers {
    public AmqpInboundChannelAdapterSpec amqp(ConnectionFactory connectionFactory, String ... queueNames) {
        return Amqp.inboundAdapter(connectionFactory, queueNames);
    }

    public AmqpInboundChannelAdapterSpec amqp(ConnectionFactory connectionFactory, Queue ... queues) {
        return Amqp.inboundAdapter(connectionFactory, queues);
    }

    public AmqpBaseInboundChannelAdapterSpec<?> inboundAdapter(SimpleMessageListenerContainer listenerContainer) {
        return Amqp.inboundAdapter(listenerContainer);
    }

    public TailAdapterSpec tail(File file) {
        return Files.tailAdapter(file);
    }

    public ImapIdleChannelAdapterSpec imap(String url) {
        return Mail.imapIdleAdapter(url);
    }

    public JmsMessageDrivenChannelAdapterSpec<? extends JmsMessageDrivenChannelAdapterSpec<?>> jms(AbstractMessageListenerContainer listenerContainer) {
        return Jms.messageDriverChannelAdapter(listenerContainer);
    }

    public JmsMessageDrivenChannelAdapterSpec<? extends JmsMessageDrivenChannelAdapterSpec<?>> jms(javax.jms.ConnectionFactory connectionFactory) {
        return Jms.messageDriverChannelAdapter(connectionFactory);
    }

    public <C extends AbstractMessageListenerContainer> JmsMessageDrivenChannelAdapterSpec<? extends JmsMessageDrivenChannelAdapterSpec<?>> jms(javax.jms.ConnectionFactory connectionFactory, Class<C> containerClass) {
        return Jms.messageDriverChannelAdapter(connectionFactory, containerClass);
    }

    public JmsMessageDrivenChannelAdapterSpec<? extends JmsMessageDrivenChannelAdapterSpec<?>> messageDriverChannelAdapter(AbstractMessageListenerContainer listenerContainer) {
        return Jms.messageDriverChannelAdapter(listenerContainer);
    }

    MessageProducers() {
    }
}

