/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.dsl.support.MessageChannelReference;
import org.springframework.integration.filter.ExpressionEvaluatingSelector;
import org.springframework.integration.router.RecipientListRouter;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.util.StringUtils;

class DslRecipientListRouter
extends RecipientListRouter {
    private final Map<String, String> expressionRecipientMap = new HashMap<String, String>();
    private final Map<String, MessageSelector> selectorRecipientMap = new HashMap<String, MessageSelector>();
    private final Map<MessageChannel, String> channelExpressionRecipientMap = new HashMap<MessageChannel, String>();
    private final Map<MessageChannel, MessageSelector> channelSelectorRecipientMap = new HashMap<MessageChannel, MessageSelector>();

    DslRecipientListRouter() {
    }

    void add(String channelName, String expression) {
        this.expressionRecipientMap.put(channelName, expression);
    }

    void add(String channelName, MessageSelector selector) {
        this.selectorRecipientMap.put(channelName, selector);
    }

    void add(MessageChannel channel, String expression) {
        this.channelExpressionRecipientMap.put(channel, expression);
    }

    void add(MessageChannel channel, MessageSelector selector) {
        this.channelSelectorRecipientMap.put(channel, selector);
    }

    /*
     * WARNING - void declaration
     */
    public void onInit() throws Exception {
        String expression;
        for (Map.Entry<String, String> entry : this.expressionRecipientMap.entrySet()) {
            void var3_7;
            Object var3_8 = null;
            expression = entry.getValue();
            if (StringUtils.hasText((String)expression)) {
                ExpressionEvaluatingSelector expressionEvaluatingSelector = new ExpressionEvaluatingSelector(expression);
                expressionEvaluatingSelector.setBeanFactory(this.getBeanFactory());
            }
            this.selectorRecipientMap.put(entry.getKey(), (MessageSelector)var3_7);
        }
        for (Map.Entry<String, String> entry : this.channelExpressionRecipientMap.entrySet()) {
            void var3_13;
            Object var3_11 = null;
            expression = entry.getValue();
            if (StringUtils.hasText((String)expression)) {
                ExpressionEvaluatingSelector expressionEvaluatingSelector = new ExpressionEvaluatingSelector(expression);
                expressionEvaluatingSelector.setBeanFactory(this.getBeanFactory());
            }
            this.channelSelectorRecipientMap.put((MessageChannel)entry.getKey(), (MessageSelector)var3_13);
        }
        ArrayList<RecipientListRouter.Recipient> recipients = new ArrayList<RecipientListRouter.Recipient>(this.selectorRecipientMap.size() + this.channelSelectorRecipientMap.size());
        for (Map.Entry<String, MessageSelector> entry : this.selectorRecipientMap.entrySet()) {
            recipients.add(new DslRecipient(new MessageChannelReference(entry.getKey()), entry.getValue()));
        }
        for (Map.Entry<MessageChannel, MessageSelector> entry : this.channelSelectorRecipientMap.entrySet()) {
            recipients.add(new RecipientListRouter.Recipient(entry.getKey(), entry.getValue()));
        }
        this.setRecipients(recipients);
        super.onInit();
    }

    class DslRecipient
    extends RecipientListRouter.Recipient {
        private volatile MessageChannel channel;

        DslRecipient(MessageChannelReference channel, MessageSelector selector) {
            super((MessageChannel)channel, selector);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessageChannel getChannel() {
            if (this.channel == null) {
                DslRecipient dslRecipient = this;
                synchronized (dslRecipient) {
                    if (this.channel == null) {
                        this.channel = this.resolveChannelName((MessageChannelReference)super.getChannel());
                    }
                }
            }
            return this.channel;
        }

        private MessageChannel resolveChannelName(MessageChannelReference channelReference) {
            String channelName = channelReference.getName();
            try {
                return (MessageChannel)DslRecipientListRouter.this.getBeanFactory().getBean(channelName, MessageChannel.class);
            }
            catch (BeansException e) {
                throw new DestinationResolutionException("Failed to look up MessageChannel with name '" + channelName + "' in the BeanFactory.");
            }
        }
    }
}

