/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.channels.SocketChannel;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.integration.ip.tcp.connection.AbstractTcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNioConnection;
import org.springframework.integration.ip.tcp.connection.TcpNioConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNioSSLConnection;
import org.springframework.integration.ip.tcp.connection.TcpSSLContextSupport;
import org.springframework.util.Assert;

public class DefaultTcpNioSSLConnectionSupport
extends AbstractTcpConnectionSupport
implements TcpNioConnectionSupport {
    private final SSLContext sslContext;
    private final boolean sslVerifyHost;

    public DefaultTcpNioSSLConnectionSupport(TcpSSLContextSupport sslContextSupport) {
        this(sslContextSupport, true);
    }

    public DefaultTcpNioSSLConnectionSupport(TcpSSLContextSupport sslContextSupport, boolean sslVerifyHost) {
        Assert.notNull((Object)sslContextSupport, (String)"TcpSSLContextSupport must not be null");
        try {
            this.sslContext = sslContextSupport.getSSLContext();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Invalid TcpSSLContextSupport - it failed to provide an SSLContext", e);
        }
        Assert.notNull((Object)this.sslContext, (String)"SSLContext retrieved from context support must not be null");
        this.sslVerifyHost = sslVerifyHost;
    }

    @Override
    public TcpNioConnection createNewConnection(SocketChannel socketChannel, boolean server, boolean lookupHost, @Nullable ApplicationEventPublisher applicationEventPublisher, @Nullable String connectionFactoryName) {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        this.postProcessSSLEngine(sslEngine);
        if (this.sslVerifyHost) {
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParameters);
        }
        TcpNioSSLConnection tcpNioSSLConnection = this.isPushbackCapable() ? new PushBackTcpNioSSLConnection(socketChannel, server, lookupHost, applicationEventPublisher, connectionFactoryName, sslEngine, this.getPushbackBufferSize()) : new TcpNioSSLConnection(socketChannel, server, lookupHost, applicationEventPublisher, connectionFactoryName, sslEngine);
        tcpNioSSLConnection.init();
        return tcpNioSSLConnection;
    }

    protected void postProcessSSLEngine(SSLEngine sslEngine) {
    }

    private static final class PushBackTcpNioSSLConnection
    extends TcpNioSSLConnection {
        private final int pushbackBufferSize;
        private final String connectionId;
        private volatile @Nullable PushbackInputStream pushbackStream;
        private volatile @Nullable InputStream wrapped;

        PushBackTcpNioSSLConnection(SocketChannel socketChannel, boolean server, boolean lookupHost, @Nullable ApplicationEventPublisher applicationEventPublisher, @Nullable String connectionFactoryName, SSLEngine sslEngine, int bufferSize) {
            super(socketChannel, server, lookupHost, applicationEventPublisher, connectionFactoryName, sslEngine);
            this.pushbackBufferSize = bufferSize;
            this.connectionId = "pushback:" + super.getConnectionId();
        }

        @Override
        protected InputStream inputStream() {
            InputStream wrappedStream = super.inputStream();
            PushbackInputStream pushbackStreamToUse = this.pushbackStream;
            if (pushbackStreamToUse == null || !wrappedStream.equals(this.wrapped)) {
                this.pushbackStream = pushbackStreamToUse = new PushbackInputStream(wrappedStream, this.pushbackBufferSize);
                this.wrapped = wrappedStream;
            }
            return pushbackStreamToUse;
        }

        @Override
        public String getConnectionId() {
            return this.connectionId;
        }
    }
}

