/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.udp.outbound;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import org.jspecify.annotations.Nullable;
import org.springframework.expression.Expression;
import org.springframework.integration.ip.udp.outbound.UnicastSendingMessageHandler;

public class MulticastSendingMessageHandler
extends UnicastSendingMessageHandler {
    private int timeToLive = -1;
    private @Nullable String localAddress;
    private volatile @Nullable MulticastSocket multicastSocket;

    public MulticastSendingMessageHandler(String address, int port) {
        super(address, port);
    }

    public MulticastSendingMessageHandler(String address, int port, boolean lengthCheck) {
        super(address, port, lengthCheck);
    }

    public MulticastSendingMessageHandler(String address, int port, boolean acknowledge, String ackHost, int ackPort, int ackTimeout) {
        super(address, port, acknowledge, ackHost, ackPort, ackTimeout);
    }

    public MulticastSendingMessageHandler(String address, int port, boolean lengthCheck, boolean acknowledge, String ackHost, int ackPort, int ackTimeout) {
        super(address, port, lengthCheck, acknowledge, ackHost, ackPort, ackTimeout);
    }

    public MulticastSendingMessageHandler(Expression destinationExpression) {
        super(destinationExpression);
    }

    public MulticastSendingMessageHandler(String destinationExpression) {
        super(destinationExpression);
    }

    public void setMinAcksForSuccess(int minAcksForSuccess) {
        this.setAckCounter(minAcksForSuccess);
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    @Override
    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    @Override
    protected DatagramSocket getSocket() throws IOException {
        this.lock.lock();
        try {
            if (this.getTheSocket() == null) {
                this.createSocket();
            }
            DatagramSocket datagramSocket = super.getSocket();
            return datagramSocket;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void createSocket() throws IOException {
        if (this.getTheSocket() == null) {
            MulticastSocket socket;
            if (this.isAcknowledge()) {
                int ackPort = this.getAckPort();
                if (this.localAddress == null) {
                    socket = new MulticastSocket(ackPort);
                } else {
                    InetAddress whichNic = InetAddress.getByName(this.localAddress);
                    socket = new MulticastSocket(new InetSocketAddress(whichNic, ackPort));
                }
                int soReceiveBufferSize = this.getSoReceiveBufferSize();
                if (soReceiveBufferSize > 0) {
                    socket.setReceiveBufferSize(soReceiveBufferSize);
                }
                this.logger.debug(() -> "Listening for acks on port: " + socket.getLocalPort());
                this.setSocket(socket);
                this.updateAckAddress();
            } else {
                socket = new MulticastSocket();
                this.setSocket(socket);
            }
            if (this.timeToLive >= 0) {
                socket.setTimeToLive(this.timeToLive);
            }
            this.setSocketAttributes(socket);
            if (this.localAddress != null) {
                socket.setNetworkInterface(NetworkInterface.getByInetAddress(InetAddress.getByName(this.localAddress)));
            }
            this.multicastSocket = socket;
        }
    }
}

