/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import org.springframework.integration.ip.tcp.serializer.AbstractPooledBufferByteArraySerializer;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;

public class ByteArrayRawSerializer
extends AbstractPooledBufferByteArraySerializer {
    public static final ByteArrayRawSerializer INSTANCE = new ByteArrayRawSerializer();
    private final boolean treatTimeoutAsEndOfMessage;

    public ByteArrayRawSerializer() {
        this(false);
    }

    public ByteArrayRawSerializer(boolean treatTimeoutAsEndOfMessage) {
        this.treatTimeoutAsEndOfMessage = treatTimeoutAsEndOfMessage;
    }

    public void serialize(byte[] bytes, OutputStream outputStream) throws IOException {
        outputStream.write(bytes);
    }

    @Override
    protected byte[] doDeserialize(InputStream inputStream, byte[] buffer) throws IOException {
        int n = 0;
        int available = inputStream.available();
        this.logger.debug(() -> "Available to read: " + available);
        try {
            while (true) {
                int bite;
                try {
                    bite = inputStream.read();
                }
                catch (SocketTimeoutException e) {
                    if (!this.treatTimeoutAsEndOfMessage) {
                        throw e;
                    }
                    bite = -1;
                }
                if (bite < 0) {
                    if (n != 0) break;
                    throw new SoftEndOfStreamException("Stream closed between payloads");
                }
                int maxMessageSize = this.getMaxMessageSize();
                if (n >= maxMessageSize) {
                    throw new IOException("Socket was not closed before max message length: " + maxMessageSize);
                }
                buffer[n++] = (byte)bite;
            }
            return this.copyToSizedArray(buffer, n);
        }
        catch (IOException | RuntimeException ex) {
            if (!(ex instanceof SoftEndOfStreamException)) {
                this.publishEvent(ex, buffer, n);
            }
            throw ex;
        }
    }
}

