/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.ip.CommonSocketOptions;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.util.Assert;

public abstract class AbstractInternetProtocolReceivingChannelAdapter
extends MessageProducerSupport
implements ApplicationEventPublisherAware,
SchedulingAwareRunnable,
CommonSocketOptions {
    private final int port;
    private ApplicationEventPublisher applicationEventPublisher;
    private int soTimeout = 0;
    private int soReceiveBufferSize = -1;
    private int receiveBufferSize = 2048;
    private @Nullable String localAddress;
    private @Nullable Executor taskExecutor;
    private boolean taskExecutorSet;
    private int poolSize = 5;
    private volatile boolean listening;

    public AbstractInternetProtocolReceivingChannelAdapter(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public void setSoReceiveBufferSize(int soReceiveBufferSize) {
        this.soReceiveBufferSize = soReceiveBufferSize;
    }

    public int getSoReceiveBufferSize() {
        return this.soReceiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public boolean isListening() {
        return this.listening;
    }

    public void setListening(boolean listening) {
        this.listening = listening;
    }

    public @Nullable String getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"'taskExecutor' cannot be null");
        this.taskExecutor = taskExecutor;
        this.taskExecutorSet = true;
    }

    public @Nullable Executor getTaskExecutor() {
        return this.taskExecutor;
    }

    protected ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected void doStart() {
        String beanName = this.getComponentName();
        this.checkTaskExecutor((String)(beanName == null ? "" : beanName + "-") + this.getComponentType());
        this.taskExecutor.execute((Runnable)((Object)this));
    }

    protected void checkTaskExecutor(String threadName) {
        if (this.isActive() && this.taskExecutor == null) {
            this.taskExecutor = Executors.newFixedThreadPool(this.poolSize, runner -> {
                Thread thread = new Thread(runner);
                thread.setName(threadName);
                thread.setDaemon(true);
                return thread;
            });
        }
    }

    protected void doStop() {
        Executor taskExecutorToShutdown = this.taskExecutor;
        if (!this.taskExecutorSet && taskExecutorToShutdown != null) {
            ((ExecutorService)taskExecutorToShutdown).shutdown();
            this.taskExecutor = null;
        }
    }
}

