/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.util.Map;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.support.MutableMessageHeaders;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;

public class MessageConvertingTcpMessageMapper
extends TcpMessageMapper {
    private final MessageConverter messageConverter;

    public MessageConvertingTcpMessageMapper(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' must not be null");
        this.messageConverter = messageConverter;
    }

    @Override
    public Message<?> toMessage(TcpConnection connection, @Nullable Map<String, Object> headers) {
        Object data = connection.getPayload();
        if (data != null) {
            MutableMessageHeaders messageHeaders = new MutableMessageHeaders(null, MessageHeaders.ID_VALUE_NONE, -1L){
                private static final long serialVersionUID = 3084692953798643018L;
            };
            this.addStandardHeaders(connection, (MessageHeaders)messageHeaders);
            this.addCustomHeaders(connection, (MessageHeaders)messageHeaders);
            if (headers != null) {
                headers.forEach((arg_0, arg_1) -> ((MessageHeaders)messageHeaders).putIfAbsent(arg_0, arg_1));
            }
            return this.messageConverter.toMessage(data, (MessageHeaders)messageHeaders);
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Null payload from connection " + connection.getConnectionId()));
        }
        return null;
    }

    @Override
    public Object fromMessage(Message<?> message) {
        return this.messageConverter.fromMessage(message, Object.class);
    }
}

