/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.util.Assert;

public class ClientModeConnectionManager
implements Runnable {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final AbstractConnectionFactory clientConnectionFactory;
    private volatile TcpConnection lastConnection;

    public ClientModeConnectionManager(AbstractConnectionFactory clientConnectionFactory) {
        Assert.notNull((Object)clientConnectionFactory, (String)"Connection factory cannot be null");
        this.clientConnectionFactory = clientConnectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AbstractConnectionFactory abstractConnectionFactory = this.clientConnectionFactory;
        synchronized (abstractConnectionFactory) {
            try {
                TcpConnection connection = this.clientConnectionFactory.getConnection();
                if (!Objects.equals(connection, this.lastConnection)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Connection " + connection.getConnectionId() + " established"));
                    }
                    this.lastConnection = connection;
                } else if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Connection " + connection.getConnectionId() + " still OK"));
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)("Could not establish connection using " + this.clientConnectionFactory), (Throwable)ex);
            }
        }
    }

    public boolean isConnected() {
        return this.lastConnection != null && this.lastConnection.isOpen();
    }
}

