/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.tcp.connection.SocketInfo;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionCloseEvent;
import org.springframework.integration.ip.tcp.connection.TcpConnectionEvent;
import org.springframework.integration.ip.tcp.connection.TcpConnectionExceptionEvent;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptor;
import org.springframework.integration.ip.tcp.connection.TcpConnectionOpenEvent;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.integration.ip.tcp.serializer.AbstractByteArraySerializer;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;

public abstract class TcpConnectionSupport
implements TcpConnection {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final CountDownLatch listenerRegisteredLatch = new CountDownLatch(1);
    private final boolean server;
    private final AtomicLong sequence = new AtomicLong();
    private final ApplicationEventPublisher applicationEventPublisher;
    private final AtomicBoolean closePublished = new AtomicBoolean();
    private final AtomicBoolean exceptionSent = new AtomicBoolean();
    private final SocketInfo socketInfo;
    private final List<TcpSender> senders = Collections.synchronizedList(new ArrayList());
    private Deserializer deserializer;
    private Serializer serializer;
    private TcpMessageMapper mapper;
    private TcpListener listener;
    private volatile TcpListener testListener;
    private String connectionId;
    private String hostName = "unknown";
    private String hostAddress = "unknown";
    private String connectionFactoryName = "unknown";
    private boolean noReadErrorOnClose;
    private boolean manualListenerRegistration;
    private boolean wrapped;
    private TcpConnectionSupport wrapper;
    private boolean needsTest;
    private volatile boolean testFailed;

    public TcpConnectionSupport() {
        this(null);
    }

    public TcpConnectionSupport(@Nullable ApplicationEventPublisher applicationEventPublisher) {
        this.server = false;
        this.applicationEventPublisher = applicationEventPublisher;
        this.socketInfo = null;
    }

    public TcpConnectionSupport(Socket socket, boolean server, boolean lookupHost, @Nullable ApplicationEventPublisher applicationEventPublisher, @Nullable String connectionFactoryName) {
        this.socketInfo = new SocketInfo(socket);
        this.server = server;
        InetAddress inetAddress = socket.getInetAddress();
        if (inetAddress != null) {
            this.hostAddress = inetAddress.getHostAddress();
            this.hostName = lookupHost ? inetAddress.getHostName() : this.hostAddress;
        }
        int port = socket.getPort();
        int localPort = socket.getLocalPort();
        this.connectionId = this.hostName + ":" + port + ":" + localPort + ":" + UUID.randomUUID().toString();
        this.applicationEventPublisher = applicationEventPublisher;
        if (connectionFactoryName != null) {
            this.connectionFactoryName = connectionFactoryName;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("New connection " + this.connectionId));
        }
    }

    void setTestFailed(boolean testFailed) {
        this.testFailed = testFailed;
    }

    @Override
    public void close() {
        if (!this.wrapped) {
            for (TcpSender sender : this.senders) {
                sender.removeDeadConnection(this);
            }
        }
        if (!this.closePublished.getAndSet(true)) {
            this.publishConnectionCloseEvent();
        }
    }

    protected void closeConnection(boolean isException) {
        TcpListener tcpListener = this.getListener();
        if (!(tcpListener instanceof TcpConnectionInterceptor)) {
            this.close();
        } else {
            TcpConnectionInterceptor nextListener;
            TcpConnectionInterceptor outerListener = (TcpConnectionInterceptor)tcpListener;
            while (outerListener.getListener() instanceof TcpConnectionInterceptor && (nextListener = (TcpConnectionInterceptor)outerListener.getListener()) != null) {
                outerListener = nextListener;
            }
            outerListener.close();
            for (TcpSender sender : this.getSenders()) {
                sender.removeDeadConnection(outerListener);
            }
            if (isException) {
                this.close();
            }
        }
    }

    public TcpMessageMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(TcpMessageMapper mapper) {
        Assert.notNull((Object)mapper, (String)(this.getClass().getName() + " Mapper may not be null"));
        this.mapper = mapper;
        if (this.serializer != null && !(this.serializer instanceof AbstractByteArraySerializer)) {
            mapper.setStringToBytes(false);
        }
    }

    @Override
    public Deserializer<?> getDeserializer() {
        return this.deserializer;
    }

    public void setDeserializer(Deserializer<?> deserializer) {
        this.deserializer = deserializer;
    }

    @Override
    public Serializer<?> getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer<?> serializer) {
        this.serializer = serializer;
        if (!(serializer instanceof AbstractByteArraySerializer)) {
            this.mapper.setStringToBytes(false);
        }
    }

    public void setNeedsTest(boolean needsTest) {
        this.needsTest = needsTest;
    }

    void setSenders(List<TcpSender> senders) {
        this.senders.addAll(senders);
    }

    public void registerListener(@Nullable TcpListener listener) {
        this.listener = listener;
        this.listenerRegisteredLatch.countDown();
    }

    public void registerTestListener(TcpListener tListener) {
        this.testListener = tListener;
    }

    public void enableManualListenerRegistration() {
        this.manualListenerRegistration = true;
        this.listener = message -> this.getListener().onMessage(message);
    }

    public void registerSender(@Nullable TcpSender senderToRegister) {
        if (senderToRegister != null) {
            this.senders.add(senderToRegister);
            senderToRegister.addNewConnection(this);
        }
    }

    public void registerSenders(List<TcpSender> sendersToRegister) {
        this.senders.addAll(sendersToRegister);
        for (TcpSender sender : sendersToRegister) {
            sender.addNewConnection(this);
        }
    }

    @Override
    public TcpListener getListener() {
        if (this.needsTest && this.testListener != null) {
            this.needsTest = false;
            return this.testListener;
        }
        if (this.manualListenerRegistration && !this.testFailed) {
            boolean debugEnabled = this.logger.isDebugEnabled();
            if (debugEnabled) {
                this.logger.debug((Object)(this.getConnectionId() + " Waiting for listener registration"));
            }
            this.waitForListenerRegistration();
            if (debugEnabled) {
                this.logger.debug((Object)(this.getConnectionId() + " Listener registered"));
            }
        }
        return this.listener;
    }

    private void waitForListenerRegistration() {
        try {
            Assert.state((boolean)this.listenerRegisteredLatch.await(1L, TimeUnit.MINUTES), (String)"TcpListener not registered");
            this.manualListenerRegistration = false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MessagingException("Interrupted while waiting for listener registration", (Throwable)e);
        }
    }

    @Nullable
    public TcpSender getSender() {
        return this.senders.size() > 0 ? this.senders.get(0) : null;
    }

    public List<TcpSender> getSenders() {
        return Collections.unmodifiableList(this.senders);
    }

    @Override
    public boolean isServer() {
        return this.server;
    }

    @Override
    public long incrementAndGetConnectionSequence() {
        return this.sequence.incrementAndGet();
    }

    @Override
    public String getHostAddress() {
        return this.hostAddress;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public String getConnectionId() {
        return this.connectionId;
    }

    @Override
    public SocketInfo getSocketInfo() {
        return this.socketInfo;
    }

    public void setWrapped(boolean wrapped) {
        this.wrapped = wrapped;
    }

    public void setWrapper(TcpConnectionSupport wrapper) {
        this.wrapper = wrapper;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    protected boolean isNoReadErrorOnClose() {
        return this.noReadErrorOnClose;
    }

    protected void setNoReadErrorOnClose(boolean noReadErrorOnClose) {
        this.noReadErrorOnClose = noReadErrorOnClose;
    }

    protected final void sendExceptionToListener(Exception e) {
        TcpListener listenerForException = this.getListener();
        if (!this.exceptionSent.getAndSet(true) && listenerForException != null) {
            Map<String, String> headers = Collections.singletonMap("ip_connectionId", this.getConnectionId());
            ErrorMessage errorMessage = new ErrorMessage((Throwable)e, headers);
            listenerForException.onMessage((Message<?>)errorMessage);
        }
    }

    protected void publishConnectionOpenEvent() {
        if (this.wrapper != null) {
            this.wrapper.publishConnectionOpenEvent();
        } else {
            this.doPublish(new TcpConnectionOpenEvent(this, this.getConnectionFactoryName()));
        }
    }

    protected void publishConnectionCloseEvent() {
        if (this.wrapper != null) {
            this.wrapper.publishConnectionCloseEvent();
        } else {
            this.doPublish(new TcpConnectionCloseEvent(this, this.getConnectionFactoryName()));
        }
    }

    protected void publishConnectionExceptionEvent(Throwable t) {
        if (this.wrapper != null) {
            this.wrapper.publishConnectionExceptionEvent(t);
        } else {
            this.doPublish(new TcpConnectionExceptionEvent(this, this.getConnectionFactoryName(), t));
        }
    }

    public void publishEvent(TcpConnectionEvent event) {
        Assert.isTrue((event.getSource() == this ? 1 : 0) != 0, (String)"Can only publish events with this as the source");
        this.doPublish(event);
    }

    private void doPublish(TcpConnectionEvent event) {
        block6: {
            try {
                if (this.applicationEventPublisher == null) {
                    this.logger.warn((Object)("No publisher available to publish " + (Object)((Object)event)));
                } else {
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Published: " + (Object)((Object)event)));
                    }
                }
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Failed to publish " + (Object)((Object)event)), (Throwable)e);
                }
                if (!this.logger.isWarnEnabled()) break block6;
                this.logger.warn((Object)("Failed to publish " + (Object)((Object)event) + ":" + e.getMessage()));
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.connectionId;
    }
}

