/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.DefaultTcpNioConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNioConnection;
import org.springframework.integration.ip.tcp.connection.TcpNioConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNioSSLConnection;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class TcpNioServerConnectionFactory
extends AbstractServerConnectionFactory {
    private final Map<SocketChannel, TcpNioConnection> channelMap = new HashMap<SocketChannel, TcpNioConnection>();
    private TcpNioConnectionSupport tcpNioConnectionSupport = new DefaultTcpNioConnectionSupport();
    private boolean multiAccept = true;
    private boolean usingDirectBuffers;
    private volatile ServerSocketChannel serverChannel;
    private volatile Selector selector;

    public TcpNioServerConnectionFactory(int port) {
        super(port);
    }

    public void setMultiAccept(boolean multiAccept) {
        this.multiAccept = multiAccept;
    }

    public String getComponentType() {
        return "tcp-nio-server-connection-factory";
    }

    @Override
    public int getPort() {
        int port = super.getPort();
        ServerSocketChannel channel = this.serverChannel;
        if (port == 0 && channel != null) {
            try {
                SocketAddress address = channel.getLocalAddress();
                if (address instanceof InetSocketAddress) {
                    port = ((InetSocketAddress)address).getPort();
                }
            }
            catch (IOException ex) {
                this.logger.error((Throwable)ex, (CharSequence)"Error getting port");
            }
        }
        return port;
    }

    @Override
    @Nullable
    public SocketAddress getServerSocketAddress() {
        if (this.serverChannel != null) {
            try {
                return this.serverChannel.getLocalAddress();
            }
            catch (IOException ex) {
                this.logger.error((Throwable)ex, (CharSequence)"Error getting local address");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.getListener() == null) {
            this.logger.info(() -> this + " No listener bound to server connection factory; will not read; exiting...");
            return;
        }
        try {
            this.serverChannel = ServerSocketChannel.open();
            int port = super.getPort();
            this.getTcpSocketSupport().postProcessServerSocket(this.serverChannel.socket());
            this.serverChannel.configureBlocking(false);
            String localAddress = this.getLocalAddress();
            if (localAddress == null) {
                this.serverChannel.socket().bind(new InetSocketAddress(port), Math.abs(this.getBacklog()));
            } else {
                InetAddress whichNic = InetAddress.getByName(localAddress);
                this.serverChannel.socket().bind(new InetSocketAddress(whichNic, port), Math.abs(this.getBacklog()));
            }
            this.logger.info(() -> this + " Listening");
            Selector theSelector = Selector.open();
            if (this.serverChannel == null) {
                this.logger.debug(() -> this + " stopped before registering the server channel");
            } else {
                this.serverChannel.register(theSelector, 16);
                this.setListening(true);
                this.publishServerListeningEvent(this.getPort());
                this.selector = theSelector;
                this.doSelect(this.serverChannel, theSelector);
            }
        }
        catch (IOException ex) {
            if (this.isActive()) {
                this.logger.error((Throwable)ex, (CharSequence)("Error on ServerChannel; port = " + this.getPort()));
                this.publishServerExceptionEvent(ex);
            }
            this.stop();
        }
        finally {
            this.setListening(false);
        }
    }

    private void doSelect(ServerSocketChannel server, Selector selectorToSelect) throws IOException {
        while (this.isActive()) {
            int soTimeout = this.getSoTimeout();
            try {
                long timeout = Math.max(soTimeout, 0);
                if (this.getDelayedReads().size() > 0 && (timeout == 0L || this.getReadDelay() < timeout)) {
                    timeout = this.getReadDelay();
                }
                long timeoutToLog = timeout;
                this.logger.trace(() -> "Delayed reads: " + this.getDelayedReads().size() + " timeout " + timeoutToLog);
                int selectionCount = selectorToSelect.select(timeout);
                this.processNioSelections(selectionCount, selectorToSelect, server, this.channelMap);
            }
            catch (CancelledKeyException cke) {
                this.logger.debug((CharSequence)"CancelledKeyException during Selector.select()");
            }
            catch (ClosedSelectorException cse) {
                if (!this.isActive()) continue;
                this.logger.error((Throwable)cse, (CharSequence)"Selector closed");
                this.publishServerExceptionEvent(cse);
                break;
            }
        }
    }

    @Override
    protected void doAccept(Selector selectorForNewSocket, ServerSocketChannel server, long now) {
        this.logger.debug((CharSequence)"New accept");
        try {
            SocketChannel channel;
            do {
                SocketChannel theChannel;
                if ((theChannel = server.accept()) != null) {
                    if (this.isShuttingDown()) {
                        this.logger.info(() -> "New connection from " + theChannel.socket().getInetAddress().getHostAddress() + ":" + theChannel.socket().getPort() + " rejected; the server is in the process of shutting down.");
                        theChannel.close();
                    } else if (this.createConnectionForAcceptedChannel(selectorForNewSocket, now, theChannel) == null) {
                        return;
                    }
                }
                channel = theChannel;
            } while (this.multiAccept && channel != null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    private TcpNioConnection createConnectionForAcceptedChannel(Selector selectorForNewSocket, long now, SocketChannel channel) throws IOException {
        TcpNioConnection connection = null;
        try {
            channel.configureBlocking(false);
            Socket socket = channel.socket();
            this.setSocketAttributes(socket);
            connection = this.createTcpNioConnection(channel);
            if (connection != null) {
                connection.setTaskExecutor(this.getTaskExecutor());
                connection.setLastRead(now);
                Integer sslHandshakeTimeout = this.getSslHandshakeTimeout();
                if (sslHandshakeTimeout != null && connection instanceof TcpNioSSLConnection) {
                    ((TcpNioSSLConnection)connection).setHandshakeTimeout(sslHandshakeTimeout);
                }
                this.channelMap.put(channel, connection);
                channel.register(selectorForNewSocket, 1, connection);
                connection.publishConnectionOpenEvent();
            }
        }
        catch (IOException ex) {
            this.logger.error((Throwable)ex, (CharSequence)("Exception accepting new connection from " + channel.socket().getInetAddress().getHostAddress() + ":" + channel.socket().getPort()));
            channel.close();
        }
        return connection;
    }

    @Nullable
    private TcpNioConnection createTcpNioConnection(SocketChannel socketChannel) {
        try {
            TcpNioConnection connection = this.tcpNioConnectionSupport.createNewConnection(socketChannel, true, this.isLookupHost(), this.getApplicationEventPublisher(), this.getComponentName());
            connection.setUsingDirectBuffers(this.usingDirectBuffers);
            TcpConnectionSupport wrappedConnection = this.wrapConnection(connection);
            this.initializeConnection(wrappedConnection, socketChannel.socket());
            return connection;
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, (CharSequence)"Failed to establish new incoming connection");
            return null;
        }
    }

    @Override
    public void stop() {
        this.setActive(false);
        if (this.selector != null) {
            try {
                this.selector.close();
            }
            catch (Exception ex) {
                this.logger.error((Throwable)ex, (CharSequence)"Error closing selector");
            }
        }
        if (this.serverChannel != null) {
            try {
                this.serverChannel.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.serverChannel = null;
            }
        }
        super.stop();
    }

    public void setUsingDirectBuffers(boolean usingDirectBuffers) {
        this.usingDirectBuffers = usingDirectBuffers;
    }

    public void setTcpNioConnectionSupport(TcpNioConnectionSupport tcpNioSupport) {
        Assert.notNull((Object)tcpNioSupport, (String)"TcpNioSupport must not be null");
        this.tcpNioConnectionSupport = tcpNioSupport;
    }

    protected ServerSocketChannel getServerChannel() {
        return this.serverChannel;
    }

    protected boolean isUsingDirectBuffers() {
        return this.usingDirectBuffers;
    }

    protected Map<SocketChannel, TcpNioConnection> getConnections() {
        return this.channelMap;
    }
}

