/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.Socket;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.integration.ip.tcp.connection.AbstractTcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNetConnection;
import org.springframework.integration.ip.tcp.connection.TcpNetConnectionSupport;

public class DefaultTcpNetConnectionSupport
extends AbstractTcpConnectionSupport
implements TcpNetConnectionSupport {
    @Override
    public TcpNetConnection createNewConnection(Socket socket, boolean server, boolean lookupHost, ApplicationEventPublisher applicationEventPublisher, String connectionFactoryName) {
        if (this.isPushbackCapable()) {
            return new PushBackTcpNetConnection(socket, server, lookupHost, applicationEventPublisher, connectionFactoryName, this.getPushbackBufferSize());
        }
        return new TcpNetConnection(socket, server, lookupHost, applicationEventPublisher, connectionFactoryName);
    }

    private static final class PushBackTcpNetConnection
    extends TcpNetConnection {
        private final int pushbackBufferSize;
        private final String connectionId;
        private volatile PushbackInputStream pushbackStream;
        private volatile InputStream wrapped;

        PushBackTcpNetConnection(Socket socket, boolean server, boolean lookupHost, ApplicationEventPublisher applicationEventPublisher, String connectionFactoryName, int bufferSize) {
            super(socket, server, lookupHost, applicationEventPublisher, connectionFactoryName);
            this.pushbackBufferSize = bufferSize;
            this.connectionId = "pushback:" + super.getConnectionId();
        }

        @Override
        protected InputStream inputStream() throws IOException {
            InputStream wrappedStream = super.inputStream();
            if (this.pushbackStream == null || !wrappedStream.equals(this.wrapped)) {
                this.pushbackStream = new PushbackInputStream(wrappedStream, this.pushbackBufferSize);
                this.wrapped = wrappedStream;
            }
            return this.pushbackStream;
        }

        @Override
        public String getConnectionId() {
            return this.connectionId;
        }
    }
}

