/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.integration.http.config.HttpContextUtils;
import org.springframework.integration.http.management.ControlBusController;
import org.springframework.integration.support.management.ControlBusCommandRegistry;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
public class ControlBusControllerConfiguration {
    private static final Log LOGGER = LogFactory.getLog(ControlBusControllerConfiguration.class);

    @Bean
    @Nullable ControlBusController controlBusController(ControlBusCommandRegistry controlBusCommandRegistry, FormattingConversionService conversionService) {
        if (!HttpContextUtils.WEB_MVC_PRESENT && !HttpContextUtils.WEB_FLUX_PRESENT) {
            LOGGER.warn((Object)"The 'IntegrationGraphController' isn't registered with the application context because there is no 'spring-mvc' or 'spring-webflux' in the classpath.");
            return null;
        }
        controlBusCommandRegistry.setEagerInitialization(true);
        return new ControlBusController(controlBusCommandRegistry, conversionService);
    }
}

