/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.inbound;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.integration.http.inbound.BaseHttpInboundEndpoint;
import org.springframework.integration.http.inbound.CrossOrigin;
import org.springframework.integration.http.inbound.HttpRequestHandlingEndpointSupport;
import org.springframework.integration.http.inbound.RequestMapping;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public final class IntegrationRequestMappingHandlerMapping
extends RequestMappingHandlerMapping
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Method HANDLE_REQUEST_METHOD = ReflectionUtils.findMethod(HttpRequestHandler.class, (String)"handleRequest", (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class});
    private final AtomicBoolean initialized = new AtomicBoolean();

    protected boolean isHandler(Class<?> beanType) {
        return HttpRequestHandlingEndpointSupport.class.isAssignableFrom(beanType);
    }

    protected HandlerExecutionChain getHandlerExecutionChain(Object handlerArg, HttpServletRequest request) {
        HandlerMethod handlerMethod;
        Object bean;
        Object handler = handlerArg;
        if (handler instanceof HandlerMethod && (bean = (handlerMethod = (HandlerMethod)handler).getBean()) instanceof HttpRequestHandlingEndpointSupport) {
            handler = bean;
        }
        return super.getHandlerExecutionChain(handler, request);
    }

    protected CorsConfiguration getCorsConfiguration(Object handler, HttpServletRequest request) {
        if (handler instanceof HandlerMethod) {
            return super.getCorsConfiguration(handler, request);
        }
        return super.getCorsConfiguration((Object)new HandlerMethod(handler, HANDLE_REQUEST_METHOD), request);
    }

    protected void detectHandlerMethods(Object handlerArg) {
        RequestMappingInfo mapping;
        Object handler = handlerArg;
        if (handler instanceof String) {
            ApplicationContext applicationContext = this.getApplicationContext();
            if (applicationContext != null) {
                handler = applicationContext.getBean((String)handler);
            } else {
                throw new IllegalStateException("No application context available to lookup bean '" + String.valueOf(handler) + "'");
            }
        }
        if ((mapping = this.getMappingForEndpoint((BaseHttpInboundEndpoint)((Object)handler))) != null) {
            this.registerMapping(mapping, handler, HANDLE_REQUEST_METHOD);
        }
    }

    protected CorsConfiguration initCorsConfiguration(Object handler, Method method, RequestMappingInfo mappingInfo) {
        CrossOrigin crossOrigin = ((BaseHttpInboundEndpoint)((Object)handler)).getCrossOrigin();
        if (crossOrigin != null) {
            return IntegrationRequestMappingHandlerMapping.buildCorsConfiguration(crossOrigin, mappingInfo);
        }
        return null;
    }

    private static CorsConfiguration buildCorsConfiguration(CrossOrigin crossOrigin, RequestMappingInfo mappingInfo) {
        CorsConfiguration config = new CorsConfiguration();
        for (RequestMethod requestMethod : crossOrigin.getMethod()) {
            config.addAllowedMethod(requestMethod.name());
        }
        config.setAllowedHeaders(Arrays.asList(crossOrigin.getAllowedHeaders()));
        config.setExposedHeaders(Arrays.asList(crossOrigin.getExposedHeaders()));
        Boolean allowCredentials = crossOrigin.getAllowCredentials();
        config.setAllowCredentials(allowCredentials);
        List<String> allowedOrigins = Arrays.asList(crossOrigin.getOrigin());
        if (Boolean.TRUE.equals(allowCredentials) && CollectionUtils.contains(allowedOrigins.iterator(), (Object)"*")) {
            config.setAllowedOriginPatterns(allowedOrigins);
        } else {
            config.setAllowedOrigins(allowedOrigins);
        }
        if (crossOrigin.getMaxAge() != -1L) {
            config.setMaxAge(Long.valueOf(crossOrigin.getMaxAge()));
        }
        if (CollectionUtils.isEmpty((Collection)config.getAllowedMethods())) {
            for (RequestMethod allowedMethod : mappingInfo.getMethodsCondition().getMethods()) {
                config.addAllowedMethod(allowedMethod.name());
            }
        }
        if (CollectionUtils.isEmpty((Collection)config.getAllowedHeaders())) {
            for (NameValueExpression headerExpression : mappingInfo.getHeadersCondition().getExpressions()) {
                if (headerExpression.isNegated()) continue;
                config.addAllowedHeader(headerExpression.getName());
            }
        }
        return config.applyPermitDefaultValues();
    }

    @Nullable
    RequestMappingInfo getMappingForEndpoint(BaseHttpInboundEndpoint endpoint) {
        RequestMapping requestMapping = endpoint.getRequestMapping();
        if (ObjectUtils.isEmpty((Object[])requestMapping.getPathPatterns())) {
            return null;
        }
        HashMap<String, Object> requestMappingAttributes = new HashMap<String, Object>();
        requestMappingAttributes.put("name", endpoint.getComponentName());
        requestMappingAttributes.put("value", requestMapping.getPathPatterns());
        requestMappingAttributes.put("path", requestMapping.getPathPatterns());
        requestMappingAttributes.put("method", requestMapping.getRequestMethods());
        requestMappingAttributes.put("params", requestMapping.getParams());
        requestMappingAttributes.put("headers", requestMapping.getHeaders());
        requestMappingAttributes.put("consumes", requestMapping.getConsumes());
        requestMappingAttributes.put("produces", requestMapping.getProduces());
        org.springframework.web.bind.annotation.RequestMapping requestMappingAnnotation = (org.springframework.web.bind.annotation.RequestMapping)AnnotationUtils.synthesizeAnnotation(requestMappingAttributes, org.springframework.web.bind.annotation.RequestMapping.class, null);
        return this.createRequestMappingInfo(requestMappingAnnotation, this.getCustomTypeCondition(((Object)((Object)endpoint)).getClass()));
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().equals((Object)this.getApplicationContext()) && !this.initialized.getAndSet(true)) {
            super.afterPropertiesSet();
        }
    }

    public void afterPropertiesSet() {
    }
}

