/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.outbound;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.integration.IntegrationPatternType;
import org.springframework.integration.expression.ExpressionEvalMap;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MimeType;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.DefaultUriBuilderFactory;

public abstract class AbstractHttpRequestExecutingMessageHandler
extends AbstractReplyProducingMessageHandler {
    private static final List<HttpMethod> NO_BODY_HTTP_METHODS = Arrays.asList(HttpMethod.GET, HttpMethod.HEAD, HttpMethod.TRACE);
    protected final DefaultUriBuilderFactory uriFactory = new DefaultUriBuilderFactory();
    private final Map<String, Expression> uriVariableExpressions = new HashMap<String, Expression>();
    private final Expression uriExpression;
    private StandardEvaluationContext evaluationContext;
    private SimpleEvaluationContext simpleEvaluationContext;
    private boolean trustedSpel;
    private Expression httpMethodExpression = new ValueExpression((Object)HttpMethod.POST);
    private boolean expectReply = true;
    private Expression expectedResponseTypeExpression;
    private boolean extractPayload = true;
    private boolean extractPayloadExplicitlySet = false;
    private boolean extractResponseBody = true;
    private Charset charset = StandardCharsets.UTF_8;
    private boolean transferCookies = false;
    private HeaderMapper<HttpHeaders> headerMapper = DefaultHttpHeaderMapper.outboundMapper();
    private Expression uriVariablesExpression;

    public AbstractHttpRequestExecutingMessageHandler(Expression uriExpression) {
        Assert.notNull((Object)uriExpression, (String)"URI Expression is required");
        this.uriExpression = uriExpression;
    }

    public void setEncodingMode(DefaultUriBuilderFactory.EncodingMode encodingMode) {
        Assert.notNull((Object)encodingMode, (String)"'encodingMode' must not be null");
        this.uriFactory.setEncodingMode(encodingMode);
    }

    public void setHttpMethodExpression(Expression httpMethodExpression) {
        Assert.notNull((Object)httpMethodExpression, (String)"'httpMethodExpression' must not be null");
        this.httpMethodExpression = httpMethodExpression;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        Assert.notNull((Object)httpMethod, (String)"'httpMethod' must not be null");
        this.httpMethodExpression = new ValueExpression((Object)httpMethod);
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
        this.extractPayloadExplicitlySet = true;
    }

    public void setCharset(String charset) {
        Assert.isTrue((boolean)Charset.isSupported(charset), () -> "unsupported charset '" + charset + "'");
        this.charset = Charset.forName(charset);
    }

    public boolean isExpectReply() {
        return this.expectReply;
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setExpectedResponseType(Class<?> expectedResponseType) {
        Assert.notNull(expectedResponseType, (String)"'expectedResponseType' must not be null");
        this.setExpectedResponseTypeExpression((Expression)new ValueExpression(expectedResponseType));
    }

    public void setExpectedResponseTypeExpression(Expression expectedResponseTypeExpression) {
        this.expectedResponseTypeExpression = expectedResponseTypeExpression;
    }

    public void setHeaderMapper(HeaderMapper<HttpHeaders> headerMapper) {
        Assert.notNull(headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUriVariableExpressions(Map<String, Expression> uriVariableExpressions) {
        Map<String, Expression> map = this.uriVariableExpressions;
        synchronized (map) {
            this.uriVariableExpressions.clear();
            this.uriVariableExpressions.putAll(uriVariableExpressions);
        }
    }

    public void setUriVariablesExpression(Expression uriVariablesExpression) {
        this.uriVariablesExpression = uriVariablesExpression;
    }

    public void setTransferCookies(boolean transferCookies) {
        this.transferCookies = transferCookies;
    }

    public void setTrustedSpel(boolean trustedSpel) {
        this.trustedSpel = trustedSpel;
    }

    public void setExtractResponseBody(boolean extractResponseBody) {
        this.extractResponseBody = extractResponseBody;
    }

    public IntegrationPatternType getIntegrationPatternType() {
        return this.expectReply ? super.getIntegrationPatternType() : IntegrationPatternType.outbound_channel_adapter;
    }

    protected void doInit() {
        BeanFactory beanFactory = this.getBeanFactory();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)beanFactory);
        this.simpleEvaluationContext = ExpressionUtils.createSimpleEvaluationContext((BeanFactory)beanFactory);
    }

    @Nullable
    protected Object handleRequestMessage(Message<?> requestMessage) {
        HttpMethod httpMethod = this.determineHttpMethod(requestMessage);
        if (this.extractPayloadExplicitlySet && !this.shouldIncludeRequestBody(httpMethod)) {
            this.logger.warn(() -> "The 'extractPayload' attribute has no relevance for the current request since the HTTP Method is '" + httpMethod + "', and no request body will be sent for that method.");
        }
        Object expectedResponseType = this.determineExpectedResponseType(requestMessage);
        HttpEntity<?> httpRequest = this.generateHttpRequest(requestMessage, httpMethod);
        Object uri = this.uriExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage);
        Assert.state((uri instanceof String || uri instanceof URI ? 1 : 0) != 0, () -> "'uriExpression' evaluation must result in a 'String' or 'URI' instance, not: " + (uri == null ? "null" : uri.getClass()));
        Map<String, ?> uriVariables = null;
        if (uri instanceof String) {
            uriVariables = this.determineUriVariables(requestMessage);
        }
        return this.exchange(uri, httpMethod, httpRequest, expectedResponseType, requestMessage, uriVariables);
    }

    @Nullable
    protected abstract Object exchange(Object var1, HttpMethod var2, HttpEntity<?> var3, Object var4, Message<?> var5, Map<String, ?> var6);

    protected Object getReply(ResponseEntity<?> httpResponse) {
        Object responseBody;
        HttpHeaders httpHeaders = httpResponse.getHeaders();
        Map headers = this.headerMapper.toHeaders((Object)httpHeaders);
        if (this.transferCookies) {
            this.doConvertSetCookie(headers);
        }
        MessageBuilderFactory messageBuilderFactory = this.getMessageBuilderFactory();
        AbstractIntegrationMessageBuilder replyBuilder = httpResponse.hasBody() && this.extractResponseBody ? ((responseBody = httpResponse.getBody()) instanceof Message ? messageBuilderFactory.fromMessage((Message)responseBody) : messageBuilderFactory.withPayload(responseBody)) : messageBuilderFactory.withPayload(httpResponse);
        replyBuilder.setHeader("http_statusCode", (Object)httpResponse.getStatusCode());
        return replyBuilder.copyHeaders(headers);
    }

    private void doConvertSetCookie(Map<String, Object> headers) {
        String keyName = null;
        for (String key : headers.keySet()) {
            if (!key.equalsIgnoreCase("Set-Cookie")) continue;
            keyName = key;
            break;
        }
        if (keyName != null) {
            Object cookies = headers.remove(keyName);
            headers.put("Cookie", cookies);
            this.logger.debug(() -> "Converted Set-Cookie header to Cookie for: " + cookies);
        }
    }

    private HttpEntity<?> generateHttpRequest(Message<?> message, HttpMethod httpMethod) {
        Assert.notNull(message, (String)"message must not be null");
        return this.extractPayload ? this.createHttpEntityFromPayload(message, httpMethod) : this.createHttpEntityFromMessage(message, httpMethod);
    }

    private HttpEntity<?> createHttpEntityFromPayload(Message<?> message, HttpMethod httpMethod) {
        MultiValueMap<Object, Object> payload = message.getPayload();
        if (payload instanceof HttpEntity) {
            return (HttpEntity)payload;
        }
        HttpHeaders httpHeaders = this.mapHeaders(message);
        if (!this.shouldIncludeRequestBody(httpMethod)) {
            return new HttpEntity((MultiValueMap)httpHeaders);
        }
        if (httpHeaders.getContentType() == null) {
            MediaType contentType = payload instanceof String ? new MediaType(MediaType.TEXT_PLAIN, this.charset) : this.resolveContentType(payload);
            httpHeaders.setContentType(contentType);
        }
        if ((MediaType.APPLICATION_FORM_URLENCODED.equalsTypeAndSubtype((MimeType)httpHeaders.getContentType()) || MediaType.MULTIPART_FORM_DATA.equalsTypeAndSubtype((MimeType)httpHeaders.getContentType())) && !(payload instanceof MultiValueMap)) {
            Assert.isInstanceOf(Map.class, (Object)payload, () -> "For " + MediaType.APPLICATION_FORM_URLENCODED + " and " + MediaType.MULTIPART_FORM_DATA + " media types the payload must be an instance of a Map.");
            payload = this.convertToMultiValueMap((Map)payload);
        }
        return new HttpEntity((Object)payload, (MultiValueMap)httpHeaders);
    }

    private HttpEntity<?> createHttpEntityFromMessage(Message<?> message, HttpMethod httpMethod) {
        HttpHeaders httpHeaders = this.mapHeaders(message);
        if (this.shouldIncludeRequestBody(httpMethod)) {
            return new HttpEntity(message, (MultiValueMap)httpHeaders);
        }
        return new HttpEntity((MultiValueMap)httpHeaders);
    }

    protected HttpHeaders mapHeaders(Message<?> message) {
        HttpHeaders httpHeaders = new HttpHeaders();
        this.headerMapper.fromHeaders(message.getHeaders(), (Object)httpHeaders);
        return httpHeaders;
    }

    @Nullable
    private MediaType resolveContentType(Object content) {
        MediaType contentType = null;
        if (content instanceof byte[]) {
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        } else if (content instanceof Source) {
            contentType = MediaType.TEXT_XML;
        } else if (content instanceof Map && this.isFormData((Map)content)) {
            contentType = this.isMultipart((Map)content) ? MediaType.MULTIPART_FORM_DATA : MediaType.APPLICATION_FORM_URLENCODED;
        }
        return contentType;
    }

    private boolean shouldIncludeRequestBody(HttpMethod httpMethod) {
        return !CollectionUtils.containsInstance(NO_BODY_HTTP_METHODS, (Object)httpMethod);
    }

    private MultiValueMap<Object, Object> convertToMultiValueMap(Map<?, ?> simpleMap) {
        LinkedMultiValueMap multipartValueMap = new LinkedMultiValueMap();
        for (Map.Entry<?, ?> entry : simpleMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Object[]) {
                value = Arrays.asList((Object[])value);
            }
            if (value instanceof Collection) {
                multipartValueMap.put(key, new ArrayList((Collection)value));
                continue;
            }
            multipartValueMap.add(key, value);
        }
        return multipartValueMap;
    }

    private boolean isFormData(Map<Object, ?> map) {
        for (Object key : map.keySet()) {
            if (key instanceof String) continue;
            return false;
        }
        return true;
    }

    private boolean isMultipart(Map<String, ?> map) {
        for (Object value : map.values()) {
            if (value == null) continue;
            if (value.getClass().isArray()) {
                value = CollectionUtils.arrayToList(value);
            }
            if (value instanceof Collection) {
                Collection cValues = (Collection)value;
                for (Object cValue : cValues) {
                    if (cValue == null || cValue instanceof String) continue;
                    return true;
                }
                continue;
            }
            if (value instanceof String) continue;
            return true;
        }
        return false;
    }

    private HttpMethod determineHttpMethod(Message<?> requestMessage) {
        Object httpMethod = this.httpMethodExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage);
        Assert.state((httpMethod instanceof String || httpMethod instanceof HttpMethod ? 1 : 0) != 0, () -> "'httpMethodExpression' evaluation must result in an 'HttpMethod' enum or its String representation, not: " + (httpMethod == null ? "null" : httpMethod.getClass()));
        if (httpMethod instanceof HttpMethod) {
            return (HttpMethod)httpMethod;
        }
        try {
            return HttpMethod.valueOf((String)((String)httpMethod));
        }
        catch (Exception ex) {
            throw new IllegalStateException("The 'httpMethodExpression' returned an invalid HTTP Method value: " + httpMethod, ex);
        }
    }

    private Object determineExpectedResponseType(Message<?> requestMessage) {
        return this.evaluateTypeFromExpression(requestMessage, this.expectedResponseTypeExpression, "expectedResponseType");
    }

    @Nullable
    protected Object evaluateTypeFromExpression(Message<?> requestMessage, @Nullable Expression expression, String property) {
        Object type = null;
        if (expression != null) {
            type = expression.getValue((EvaluationContext)this.evaluationContext, requestMessage);
        }
        if (type != null) {
            Class<?> typeClass = type.getClass();
            Assert.state((type instanceof Class || type instanceof String || type instanceof ParameterizedTypeReference ? 1 : 0) != 0, () -> "The '" + property + "' can be an instance of 'Class<?>', 'String' or 'ParameterizedTypeReference<?>'; evaluation resulted in a " + typeClass + ".");
            if (type instanceof String && StringUtils.hasText((String)((String)type))) {
                try {
                    ApplicationContext applicationContext = this.getApplicationContext();
                    type = ClassUtils.forName((String)((String)type), (ClassLoader)(applicationContext == null ? null : applicationContext.getClassLoader()));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Cannot load class for name: " + type, e);
                }
            }
        }
        return type;
    }

    private Map<String, ?> determineUriVariables(Message<?> requestMessage) {
        Map expressions;
        StandardEvaluationContext evaluationContextToUse = this.evaluationContext;
        if (this.uriVariablesExpression != null) {
            Object expressionsObject = this.uriVariablesExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage);
            Assert.state((boolean)(expressionsObject instanceof Map), (String)"The 'uriVariablesExpression' evaluation must result in a 'Map'.");
            expressions = (Map)expressionsObject;
            if (!this.trustedSpel) {
                evaluationContextToUse = this.simpleEvaluationContext;
            }
        } else {
            expressions = this.uriVariableExpressions;
        }
        return ExpressionEvalMap.from(expressions).usingEvaluationContext((EvaluationContext)evaluationContextToUse).withRoot(requestMessage).build();
    }
}

