/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.config;

import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.http.config.HttpAdapterParsingUtils;
import org.springframework.integration.http.outbound.HttpRequestExecutingMessageHandler;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class HttpOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBuilder(element, parserContext);
        builder.addPropertyValue("expectReply", (Object)false);
        HttpAdapterParsingUtils.configureUrlConstructorArg(element, parserContext, builder);
        HttpAdapterParsingUtils.setHttpMethodOrExpression(element, parserContext, builder);
        String headerMapper = element.getAttribute("header-mapper");
        String mappedRequestHeaders = element.getAttribute("mapped-request-headers");
        if (StringUtils.hasText((String)headerMapper)) {
            if (StringUtils.hasText((String)mappedRequestHeaders)) {
                parserContext.getReaderContext().error("The 'mapped-request-headers' attribute is not allowed when a 'header-mapper' has been specified.", parserContext.extractSource((Object)element));
                return null;
            }
            builder.addPropertyReference("headerMapper", headerMapper);
        } else if (StringUtils.hasText((String)mappedRequestHeaders)) {
            BeanDefinitionBuilder headerMapperBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultHttpHeaderMapper.class);
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)headerMapperBuilder, (Element)element, (String)"mapped-request-headers", (String)"outboundHeaderNames");
            builder.addPropertyValue("headerMapper", (Object)headerMapperBuilder.getBeanDefinition());
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"charset");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-payload");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"trusted-spel");
        HttpAdapterParsingUtils.setExpectedResponseOrExpression(element, parserContext, builder);
        HttpAdapterParsingUtils.configureUriVariableExpressions(builder, parserContext, element);
        return builder.getBeanDefinition();
    }

    protected BeanDefinitionBuilder getBuilder(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HttpRequestExecutingMessageHandler.class);
        String restTemplateRef = element.getAttribute("rest-template");
        if (StringUtils.hasText((String)restTemplateRef)) {
            HttpAdapterParsingUtils.verifyNoRestTemplateAttributes(element, parserContext);
            builder.getBeanDefinition().getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)new RuntimeBeanReference(restTemplateRef));
        } else {
            for (String referenceAttributeName : HttpAdapterParsingUtils.SYNC_REST_TEMPLATE_REFERENCE_ATTRIBUTES) {
                IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)referenceAttributeName);
            }
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"encode-uri");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"encoding-mode");
        }
        return builder;
    }
}

