/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.inbound;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.ResolvableType;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.http.inbound.CrossOrigin;
import org.springframework.integration.http.inbound.RequestMapping;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class BaseHttpInboundEndpoint
extends MessagingGatewaySupport
implements OrderlyShutdownCapable {
    protected static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)BaseHttpInboundEndpoint.class.getClassLoader());
    protected static final boolean romeToolsPresent = ClassUtils.isPresent((String)"com.rometools.rome.feed.atom.Feed", (ClassLoader)BaseHttpInboundEndpoint.class.getClassLoader());
    protected static final List<HttpMethod> nonReadableBodyHttpMethods = Arrays.asList(HttpMethod.GET, HttpMethod.HEAD, HttpMethod.OPTIONS);
    protected final boolean expectReply;
    protected final AtomicInteger activeCount = new AtomicInteger();
    private ResolvableType requestPayloadType = null;
    private HeaderMapper<HttpHeaders> headerMapper = DefaultHttpHeaderMapper.inboundMapper();
    private boolean extractReplyPayload = true;
    private Expression statusCodeExpression;
    private EvaluationContext evaluationContext;
    private RequestMapping requestMapping = new RequestMapping();
    private Expression payloadExpression;
    private Map<String, Expression> headerExpressions;
    private CrossOrigin crossOrigin;

    public BaseHttpInboundEndpoint(boolean expectReply) {
        super(expectReply);
        this.expectReply = expectReply;
    }

    public void setPayloadExpression(Expression payloadExpression) {
        this.payloadExpression = payloadExpression;
    }

    public void setHeaderExpressions(Map<String, Expression> headerExpressions) {
        this.headerExpressions = headerExpressions;
    }

    public void setRequestMapping(RequestMapping requestMapping) {
        Assert.notNull((Object)requestMapping, (String)"requestMapping must not be null");
        this.requestMapping = requestMapping;
    }

    public final RequestMapping getRequestMapping() {
        return this.requestMapping;
    }

    public void setCrossOrigin(CrossOrigin crossOrigin) {
        this.crossOrigin = crossOrigin;
    }

    public CrossOrigin getCrossOrigin() {
        return this.crossOrigin;
    }

    protected Expression getPayloadExpression() {
        return this.payloadExpression;
    }

    protected Map<String, Expression> getHeaderExpressions() {
        return this.headerExpressions;
    }

    protected boolean isExpectReply() {
        return this.expectReply;
    }

    public void setHeaderMapper(HeaderMapper<HttpHeaders> headerMapper) {
        Assert.notNull(headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    protected HeaderMapper<HttpHeaders> getHeaderMapper() {
        return this.headerMapper;
    }

    public void setRequestPayloadTypeClass(Class<?> requestPayloadType) {
        this.setRequestPayloadType(ResolvableType.forClass(requestPayloadType));
    }

    public void setRequestPayloadType(ResolvableType requestPayloadType) {
        this.requestPayloadType = requestPayloadType;
    }

    protected ResolvableType getRequestPayloadType() {
        return this.requestPayloadType;
    }

    public void setExtractReplyPayload(boolean extractReplyPayload) {
        this.extractReplyPayload = extractReplyPayload;
    }

    protected boolean getExtractReplyPayload() {
        return this.extractReplyPayload;
    }

    public void setStatusCodeExpressionString(String statusCodeExpression) {
        this.setStatusCodeExpression(EXPRESSION_PARSER.parseExpression(statusCodeExpression));
    }

    public void setStatusCodeExpression(Expression statusCodeExpression) {
        this.statusCodeExpression = statusCodeExpression;
    }

    protected Expression getStatusCodeExpression() {
        return this.statusCodeExpression;
    }

    protected void onInit() {
        super.onInit();
        this.validateSupportedMethods();
        if (this.statusCodeExpression != null) {
            this.evaluationContext = this.createEvaluationContext();
        }
        this.getRequestMapping().setName(this.getComponentName());
    }

    private void validateSupportedMethods() {
        if (this.requestPayloadType != null && CollectionUtils.containsAny(nonReadableBodyHttpMethods, Arrays.asList(this.getRequestMapping().getMethods())) && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("The 'requestPayloadType' attribute will have no relevance for one of the specified HTTP methods '" + nonReadableBodyHttpMethods + "'"));
        }
    }

    protected HttpStatus evaluateHttpStatus(HttpEntity<?> httpEntity) {
        if (this.statusCodeExpression != null) {
            Object value = this.statusCodeExpression.getValue(this.evaluationContext, httpEntity);
            return this.buildHttpStatus(value);
        }
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }

    protected HttpStatus resolveHttpStatusFromHeaders(MessageHeaders headers) {
        Object httpStatusFromHeader = headers.get((Object)"http_statusCode");
        return this.buildHttpStatus(httpStatusFromHeader);
    }

    private HttpStatus buildHttpStatus(Object httpStatusValue) {
        HttpStatus httpStatus = null;
        if (httpStatusValue instanceof HttpStatus) {
            httpStatus = (HttpStatus)httpStatusValue;
        } else if (httpStatusValue instanceof Integer) {
            httpStatus = HttpStatus.valueOf((int)((Integer)httpStatusValue));
        } else if (httpStatusValue instanceof String) {
            httpStatus = HttpStatus.valueOf((int)Integer.parseInt((String)httpStatusValue));
        }
        return httpStatus;
    }

    protected StandardEvaluationContext createEvaluationContext() {
        return ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    public int beforeShutdown() {
        this.stop();
        return this.activeCount.get();
    }

    public int afterShutdown() {
        return this.activeCount.get();
    }

    public String getComponentType() {
        return this.expectReply ? "http:inbound-gateway" : "http:inbound-channel-adapter";
    }

    protected boolean isReadable(HttpRequest request) {
        return !CollectionUtils.containsInstance(nonReadableBodyHttpMethods, (Object)request.getMethod());
    }
}

