/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.converter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.xml.XmlAwareFormHttpMessageConverter;
import org.springframework.integration.http.multipart.DefaultMultipartFileReader;
import org.springframework.integration.http.multipart.MultipartFileReader;
import org.springframework.integration.http.multipart.MultipartHttpInputMessage;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartAwareFormHttpMessageConverter
implements HttpMessageConverter<MultiValueMap<String, ?>> {
    private volatile MultipartFileReader<?> multipartFileReader = new DefaultMultipartFileReader();
    private final XmlAwareFormHttpMessageConverter wrappedConverter = new XmlAwareFormHttpMessageConverter();

    public void setCharset(Charset charset) {
        this.wrappedConverter.setCharset(charset);
    }

    public void setMultipartFileReader(MultipartFileReader<?> multipartFileReader) {
        Assert.notNull(multipartFileReader, (String)"multipartFileReader must not be null");
        this.multipartFileReader = multipartFileReader;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.wrappedConverter.getSupportedMediaTypes();
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        if (!MultiValueMap.class.isAssignableFrom(clazz) && !byte[].class.isAssignableFrom(clazz)) {
            return false;
        }
        if (mediaType != null) {
            return MediaType.APPLICATION_FORM_URLENCODED.includes(mediaType) || MediaType.MULTIPART_FORM_DATA.includes(mediaType);
        }
        return true;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return this.wrappedConverter.canWrite(clazz, mediaType);
    }

    public MultiValueMap<String, ?> read(Class<? extends MultiValueMap<String, ?>> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        MediaType contentType = inputMessage.getHeaders().getContentType();
        if (!MediaType.MULTIPART_FORM_DATA.includes(contentType)) {
            return this.wrappedConverter.read(clazz, inputMessage);
        }
        Assert.state((boolean)(inputMessage instanceof MultipartHttpInputMessage), (String)"A request with 'multipart/form-data' Content-Type must be a MultipartHttpInputMessage. Be sure to provide a 'multipartResolver' bean in the ApplicationContext.");
        MultipartHttpInputMessage multipartInputMessage = (MultipartHttpInputMessage)inputMessage;
        return this.readMultipart(multipartInputMessage);
    }

    private MultiValueMap<String, ?> readMultipart(MultipartHttpInputMessage multipartRequest) throws IOException {
        LinkedMultiValueMap resultMap = new LinkedMultiValueMap();
        Map parameterMap = multipartRequest.getParameterMap();
        for (Object key : parameterMap.keySet()) {
            resultMap.add((Object)((String)key), parameterMap.get(key));
        }
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        for (Map.Entry<String, MultipartFile> entry : fileMap.entrySet()) {
            MultipartFile multipartFile = entry.getValue();
            if (multipartFile.isEmpty()) continue;
            resultMap.add((Object)entry.getKey(), this.multipartFileReader.readMultipartFile(multipartFile));
        }
        return resultMap;
    }

    public void write(MultiValueMap<String, ?> map, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        this.wrappedConverter.write(map, contentType, outputMessage);
    }
}

