/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.groovy;

import groovy.lang.Binding;
import groovy.lang.GString;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import groovy.transform.CompileStatic;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.integration.groovy.BindingOverwriteGroovyObjectCustomizerDecorator;
import org.springframework.integration.groovy.VariableBindingGroovyObjectCustomizerDecorator;
import org.springframework.integration.scripting.AbstractScriptExecutingMessageProcessor;
import org.springframework.integration.scripting.ScriptVariableGenerator;
import org.springframework.messaging.Message;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.groovy.GroovyObjectCustomizer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class GroovyScriptExecutingMessageProcessor
extends AbstractScriptExecutingMessageProcessor<Object>
implements InitializingBean {
    private final VariableBindingGroovyObjectCustomizerDecorator customizerDecorator = new VariableBindingGroovyObjectCustomizerDecorator();
    private final Lock scriptLock = new ReentrantLock();
    private volatile ScriptSource scriptSource;
    private volatile GroovyClassLoader groovyClassLoader = AccessController.doPrivileged(() -> new GroovyClassLoader(ClassUtils.getDefaultClassLoader()));
    private volatile Class<?> scriptClass;
    private boolean compileStatic;
    private CompilerConfiguration compilerConfiguration;

    public GroovyScriptExecutingMessageProcessor(ScriptSource scriptSource) {
        this.scriptSource = scriptSource;
    }

    public GroovyScriptExecutingMessageProcessor(ScriptSource scriptSource, ScriptVariableGenerator scriptVariableGenerator) {
        super(scriptVariableGenerator);
        this.scriptSource = scriptSource;
    }

    public void setCustomizer(GroovyObjectCustomizer customizer) {
        this.customizerDecorator.setCustomizer(customizer);
    }

    public void setCompileStatic(boolean compileStatic) {
        this.compileStatic = compileStatic;
    }

    public void setCompilerConfiguration(CompilerConfiguration compilerConfiguration) {
        this.compilerConfiguration = compilerConfiguration;
    }

    protected ScriptSource getScriptSource(Message<?> message) {
        return this.scriptSource;
    }

    public void afterPropertiesSet() throws Exception {
        CompilerConfiguration compilerConfiguration;
        if (this.beanFactory != null && this.beanFactory instanceof ConfigurableListableBeanFactory) {
            ((ConfigurableListableBeanFactory)this.beanFactory).ignoreDependencyType(MetaClass.class);
        }
        if ((compilerConfiguration = this.compilerConfiguration) == null && this.compileStatic) {
            compilerConfiguration = new CompilerConfiguration();
            compilerConfiguration.addCompilationCustomizers(new CompilationCustomizer[]{new ASTTransformationCustomizer(CompileStatic.class)});
        }
        this.groovyClassLoader = new GroovyClassLoader(this.beanClassLoader, compilerConfiguration);
    }

    protected Object executeScript(ScriptSource scriptSource, Map<String, Object> variables) throws Exception {
        Assert.notNull((Object)scriptSource, (String)"scriptSource must not be null");
        this.parseScriptIfNecessary(scriptSource);
        Object result = this.execute(variables);
        return result instanceof GString ? result.toString() : result;
    }

    private void parseScriptIfNecessary(ScriptSource scriptSource) throws Exception {
        if (this.scriptClass == null || scriptSource.isModified()) {
            this.scriptLock.lockInterruptibly();
            try {
                if (this.scriptClass == null || scriptSource.isModified()) {
                    String className = scriptSource.suggestedClassName();
                    this.scriptClass = StringUtils.hasText((String)className) ? this.groovyClassLoader.parseClass(scriptSource.getScriptAsString(), className) : this.groovyClassLoader.parseClass(scriptSource.getScriptAsString());
                }
            }
            finally {
                this.scriptLock.unlock();
            }
        }
    }

    private Object execute(Map<String, Object> variables) throws ScriptCompilationException {
        try {
            GroovyObject goo = (GroovyObject)this.scriptClass.newInstance();
            BindingOverwriteGroovyObjectCustomizerDecorator groovyObjectCustomizer = new BindingOverwriteGroovyObjectCustomizerDecorator(new BeanFactoryFallbackBinding(variables));
            groovyObjectCustomizer.setCustomizer(this.customizerDecorator);
            if (goo instanceof Script) {
                ((VariableBindingGroovyObjectCustomizerDecorator)groovyObjectCustomizer).customize(goo);
                return ((Script)goo).run();
            }
            return goo;
        }
        catch (InstantiationException ex) {
            throw new ScriptCompilationException(this.scriptSource, "Could not instantiate Groovy script class: " + this.scriptClass.getName(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new ScriptCompilationException(this.scriptSource, "Could not access Groovy script constructor: " + this.scriptClass.getName(), (Throwable)ex);
        }
    }

    private final class BeanFactoryFallbackBinding
    extends Binding {
        private BeanFactoryFallbackBinding(Map<?, ?> variables) {
            super(variables);
        }

        public Object getVariable(String name) {
            try {
                return super.getVariable(name);
            }
            catch (MissingPropertyException missingPropertyException) {
                if (GroovyScriptExecutingMessageProcessor.this.beanFactory == null) {
                    throw new MissingPropertyException(name, ((Object)((Object)this)).getClass());
                }
                try {
                    return GroovyScriptExecutingMessageProcessor.this.beanFactory.getBean(name);
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new MissingPropertyException(name, ((Object)((Object)this)).getClass(), (Throwable)e);
                }
            }
        }
    }
}

