/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.groovy;

import groovy.lang.Binding;
import groovy.lang.GString;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.integration.groovy.BindingOverwriteGroovyObjectCustomizerDecorator;
import org.springframework.integration.groovy.VariableBindingGroovyObjectCustomizerDecorator;
import org.springframework.integration.scripting.AbstractScriptExecutingMessageProcessor;
import org.springframework.integration.scripting.ScriptVariableGenerator;
import org.springframework.messaging.Message;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.groovy.GroovyObjectCustomizer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class GroovyScriptExecutingMessageProcessor
extends AbstractScriptExecutingMessageProcessor<Object> {
    private final VariableBindingGroovyObjectCustomizerDecorator customizerDecorator = new VariableBindingGroovyObjectCustomizerDecorator();
    private final Lock scriptLock = new ReentrantLock();
    private volatile ScriptSource scriptSource;
    private volatile GroovyClassLoader groovyClassLoader = new GroovyClassLoader(ClassUtils.getDefaultClassLoader());
    private volatile Class<?> scriptClass;

    public GroovyScriptExecutingMessageProcessor(ScriptSource scriptSource) {
        this.scriptSource = scriptSource;
    }

    public GroovyScriptExecutingMessageProcessor(ScriptSource scriptSource, ScriptVariableGenerator scriptVariableGenerator) {
        super(scriptVariableGenerator);
        this.scriptSource = scriptSource;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
        this.groovyClassLoader = new GroovyClassLoader(classLoader);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(beanFactory);
        if (beanFactory != null && beanFactory instanceof ConfigurableListableBeanFactory) {
            ((ConfigurableListableBeanFactory)beanFactory).ignoreDependencyType(MetaClass.class);
        }
    }

    public void setCustomizer(GroovyObjectCustomizer customizer) {
        this.customizerDecorator.setCustomizer(customizer);
    }

    protected ScriptSource getScriptSource(Message<?> message) {
        return this.scriptSource;
    }

    protected Object executeScript(ScriptSource scriptSource, Map<String, Object> variables) throws Exception {
        Assert.notNull((Object)scriptSource, (String)"scriptSource must not be null");
        this.parseScriptIfNecessary(scriptSource);
        Object result = this.execute(variables);
        return result instanceof GString ? result.toString() : result;
    }

    private void parseScriptIfNecessary(ScriptSource scriptSource) throws Exception {
        if (this.scriptClass == null || scriptSource.isModified()) {
            this.scriptLock.lockInterruptibly();
            try {
                if (this.scriptClass == null || scriptSource.isModified()) {
                    this.scriptClass = this.groovyClassLoader.parseClass(scriptSource.getScriptAsString(), scriptSource.suggestedClassName());
                }
            }
            finally {
                this.scriptLock.unlock();
            }
        }
    }

    private Object execute(Map<String, Object> variables) throws ScriptCompilationException {
        try {
            GroovyObject goo = (GroovyObject)this.scriptClass.newInstance();
            BindingOverwriteGroovyObjectCustomizerDecorator groovyObjectCustomizer = new BindingOverwriteGroovyObjectCustomizerDecorator(new BeanFactoryFallbackBinding(variables));
            groovyObjectCustomizer.setCustomizer(this.customizerDecorator);
            if (goo instanceof Script) {
                ((VariableBindingGroovyObjectCustomizerDecorator)groovyObjectCustomizer).customize(goo);
                return ((Script)goo).run();
            }
            return goo;
        }
        catch (InstantiationException ex) {
            throw new ScriptCompilationException(this.scriptSource, "Could not instantiate Groovy script class: " + this.scriptClass.getName(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new ScriptCompilationException(this.scriptSource, "Could not access Groovy script constructor: " + this.scriptClass.getName(), (Throwable)ex);
        }
    }

    private class BeanFactoryFallbackBinding
    extends Binding {
        private BeanFactoryFallbackBinding(Map<?, ?> variables) {
            super(variables);
        }

        public Object getVariable(String name) {
            try {
                return super.getVariable(name);
            }
            catch (MissingPropertyException missingPropertyException) {
                if (GroovyScriptExecutingMessageProcessor.this.beanFactory == null) {
                    throw new MissingPropertyException(name, ((Object)((Object)this)).getClass());
                }
                try {
                    return GroovyScriptExecutingMessageProcessor.this.beanFactory.getBean(name);
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new MissingPropertyException(name, ((Object)((Object)this)).getClass(), (Throwable)e);
                }
            }
        }
    }
}

