/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gemfire.outbound;

import com.gemstone.gemfire.GemFireCheckedException;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.Region;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.gemfire.GemfireCallback;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class CacheWritingMessageHandler
extends AbstractMessageHandler {
    private final Map<Expression, Expression> cacheEntryExpressions = new LinkedHashMap<Expression, Expression>();
    private final GemfireTemplate gemfireTemplate = new GemfireTemplate();

    public CacheWritingMessageHandler(Region region) {
        Assert.notNull((Object)region, (String)"region must not be null");
        this.gemfireTemplate.setRegion(region);
        this.gemfireTemplate.afterPropertiesSet();
    }

    public String getComponentType() {
        return "gemfire:outbound-channel-adapter";
    }

    public void handleMessageInternal(Message<?> message) {
        Map cacheValues;
        Object payload = message.getPayload();
        Map map = cacheValues = this.cacheEntryExpressions.size() > 0 ? this.parseCacheEntries(message) : null;
        if (cacheValues == null) {
            Assert.isTrue((boolean)(payload instanceof Map), (String)"If cache entry expressions are not configured, then payload must be a Map");
            cacheValues = (Map)payload;
        }
        final Map map2 = cacheValues;
        this.gemfireTemplate.execute((GemfireCallback)new GemfireCallback<Object>(){

            public Object doInGemfire(Region region) throws GemFireCheckedException, GemFireException {
                region.putAll(map2);
                return null;
            }
        });
    }

    private Map<Object, Object> parseCacheEntries(Message<?> message) {
        if (this.cacheEntryExpressions.size() == 0) {
            return null;
        }
        HashMap<Object, Object> cacheValues = new HashMap<Object, Object>();
        for (Map.Entry<Expression, Expression> expressionEntry : this.cacheEntryExpressions.entrySet()) {
            cacheValues.put(expressionEntry.getKey().getValue(message), expressionEntry.getValue().getValue(message));
        }
        return cacheValues;
    }

    public void setCacheEntries(Map<String, String> cacheEntries) {
        if (this.cacheEntryExpressions.size() > 0) {
            this.cacheEntryExpressions.clear();
        }
        for (Map.Entry<String, String> cacheEntry : cacheEntries.entrySet()) {
            this.cacheEntryExpressions.put(new SpelExpressionParser().parseExpression(cacheEntry.getKey()), new SpelExpressionParser().parseExpression(cacheEntry.getValue()));
        }
    }
}

