/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.inbound;

import org.apache.commons.net.ftp.FTPFile;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizer;

public class FtpInboundFileSynchronizer
extends AbstractInboundFileSynchronizer<FTPFile> {
    public FtpInboundFileSynchronizer(SessionFactory<FTPFile> sessionFactory) {
        super(sessionFactory);
        this.setRemoteDirectoryExpression((Expression)new LiteralExpression(null));
    }

    protected boolean isFile(FTPFile file) {
        return file != null && file.isFile();
    }

    protected String getFilename(FTPFile file) {
        return file != null ? file.getName() : null;
    }

    protected long getModified(FTPFile file) {
        return file.getTimestamp().getTimeInMillis();
    }
}

