/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.file.filters.AbstractFileListFilter;
import org.springframework.util.Assert;

public class ExpressionFileListFilter<F>
extends AbstractFileListFilter<F>
implements BeanFactoryAware {
    private static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private final Expression expression;
    private BeanFactory beanFactory;
    private @Nullable EvaluationContext evaluationContext;

    public ExpressionFileListFilter(String expression) {
        this(EXPRESSION_PARSER.parseExpression(expression));
        Assert.hasText((String)expression, (String)"'expression' must not be empty");
    }

    public ExpressionFileListFilter(Expression expression) {
        Assert.notNull((Object)expression, (String)"'expression' must not be null");
        this.expression = expression;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public boolean accept(F file) {
        Boolean pass = (Boolean)this.expression.getValue(this.getEvaluationContext(), file, Boolean.class);
        return Boolean.TRUE.equals(pass);
    }

    private EvaluationContext getEvaluationContext() {
        if (this.evaluationContext == null) {
            this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.beanFactory);
        }
        return this.evaluationContext;
    }
}

