/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.file.filters.FileListFilter;

public abstract class AbstractRecentFileListFilter<F>
implements FileListFilter<F> {
    protected static final long ONE_SECOND = 1000L;
    private final Duration age;

    public AbstractRecentFileListFilter() {
        this(Duration.ofDays(1L));
    }

    public AbstractRecentFileListFilter(Duration age) {
        this.age = age;
    }

    @Override
    public boolean supportsSingleFileFiltering() {
        return true;
    }

    @Override
    public List<F> filterFiles(F @Nullable [] files) {
        if (files != null) {
            ArrayList<F> list = new ArrayList<F>(files.length);
            Instant now = Instant.now();
            for (F file : files) {
                if (this.fileIsAged(file, now)) continue;
                list.add(file);
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean accept(F file) {
        return !this.fileIsAged(file, Instant.now());
    }

    protected boolean fileIsAged(F file, Instant now) {
        return this.getLastModified(file).plus(this.age).isBefore(now);
    }

    protected abstract Instant getLastModified(F var1);
}

