/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.file.config.FileParserUtils;
import org.springframework.integration.file.filters.RegexPatternFileListFilter;
import org.springframework.integration.file.filters.SimplePatternFileListFilter;
import org.springframework.integration.file.remote.RemoteFileOperations;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class AbstractRemoteFileOutboundGatewayParser
extends AbstractConsumerEndpointParser {
    protected String getInputChannelAttributeName() {
        return "request-channel";
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinition templateDefinition = FileParserUtils.parseRemoteFileTemplate(element, parserContext, false, this.getTemplateClass());
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)this.getGatewayClassName());
        builder.addConstructorArgValue((Object)templateDefinition);
        if (element.hasAttribute("session-callback")) {
            builder.addConstructorArgReference(element.getAttribute("session-callback"));
        } else {
            builder.addConstructorArgValue((Object)element.getAttribute("command"));
            builder.addConstructorArgValue((Object)element.getAttribute("expression"));
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"command-options", (String)"options");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout", (String)"sendTimeout");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel", (String)"outputChannel");
        this.configureFilter(builder, element, parserContext, "filter", "filename", "filter");
        this.configureFilter(builder, element, parserContext, "mput-filter", "mput", "mputFilter");
        BeanDefinition localDirExpressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"local-directory", (String)"local-directory-expression", (ParserContext)parserContext, (Element)element, (boolean)false);
        builder.addPropertyValue("localDirectoryExpression", (Object)localDirExpressionDef);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-create-local-directory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"order");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"rename-expression");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"requires-reply");
        String localFileGeneratorExpression = element.getAttribute("local-filename-generator-expression");
        if (StringUtils.hasText((String)localFileGeneratorExpression)) {
            BeanDefinitionBuilder localFileGeneratorExpressionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class);
            localFileGeneratorExpressionBuilder.addConstructorArgValue((Object)localFileGeneratorExpression);
            builder.addPropertyValue("localFilenameGeneratorExpression", (Object)localFileGeneratorExpressionBuilder.getBeanDefinition());
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"mode", (String)"fileExistsMode");
        return builder;
    }

    protected void configureFilter(BeanDefinitionBuilder builder, Element element, ParserContext parserContext, String filterAttribute, String patternPrefix, String propertyName) {
        String filter = element.getAttribute(filterAttribute);
        String fileNamePattern = element.getAttribute(patternPrefix + "-pattern");
        String fileNameRegex = element.getAttribute(patternPrefix + "-regex");
        boolean hasFilter = StringUtils.hasText((String)filter);
        boolean hasFileNamePattern = StringUtils.hasText((String)fileNamePattern);
        boolean hasFileNameRegex = StringUtils.hasText((String)fileNameRegex);
        int count = hasFilter ? 1 : 0;
        count += hasFileNamePattern ? 1 : 0;
        if ((count += hasFileNameRegex ? 1 : 0) > 1) {
            parserContext.getReaderContext().error("at most one of '" + patternPrefix + "-pattern', " + "'" + patternPrefix + "-regex', or '" + filterAttribute + "' is allowed on a remote file outbound gateway", (Object)element);
        } else if (hasFilter) {
            builder.addPropertyReference(propertyName, filter);
        } else if (hasFileNamePattern) {
            BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)("filter".equals(filterAttribute) ? this.getSimplePatternFileListFilterClassName() : SimplePatternFileListFilter.class.getName()));
            filterBuilder.addConstructorArgValue((Object)fileNamePattern);
            builder.addPropertyValue(propertyName, (Object)filterBuilder.getBeanDefinition());
        } else if (hasFileNameRegex) {
            BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)("filter".equals(filterAttribute) ? this.getRegexPatternFileListFilterClassName() : RegexPatternFileListFilter.class.getName()));
            filterBuilder.addConstructorArgValue((Object)fileNameRegex);
            builder.addPropertyValue(propertyName, (Object)filterBuilder.getBeanDefinition());
        }
    }

    protected abstract String getRegexPatternFileListFilterClassName();

    protected abstract String getSimplePatternFileListFilterClassName();

    protected abstract String getGatewayClassName();

    protected abstract Class<? extends RemoteFileOperations<?>> getTemplateClass();
}

