/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.ReversibleFileListFilter;
import org.springframework.util.Assert;

public class CompositeFileListFilter<F>
implements ReversibleFileListFilter<F>,
Closeable {
    private final Set<FileListFilter<F>> fileFilters;

    public CompositeFileListFilter() {
        this.fileFilters = new LinkedHashSet<FileListFilter<F>>();
    }

    public CompositeFileListFilter(Collection<? extends FileListFilter<F>> fileFilters) {
        this.fileFilters = new LinkedHashSet<FileListFilter<F>>(fileFilters);
    }

    @Override
    public void close() throws IOException {
        for (FileListFilter<F> filter : this.fileFilters) {
            if (!(filter instanceof Closeable)) continue;
            ((Closeable)((Object)filter)).close();
        }
    }

    public CompositeFileListFilter<F> addFilter(FileListFilter<F> filter) {
        return this.addFilters(Collections.singletonList(filter));
    }

    public CompositeFileListFilter<F> addFilters(FileListFilter<F> ... filters) {
        return this.addFilters(Arrays.asList(filters));
    }

    public CompositeFileListFilter<F> addFilters(Collection<? extends FileListFilter<F>> filtersToAdd) {
        for (FileListFilter<F> elf : filtersToAdd) {
            if (!(elf instanceof InitializingBean)) continue;
            try {
                ((InitializingBean)elf).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.fileFilters.addAll(filtersToAdd);
        return this;
    }

    @Override
    public List<F> filterFiles(F[] files) {
        Assert.notNull(files, (String)"'files' should not be null");
        ArrayList<F> results = new ArrayList<F>(Arrays.asList(files));
        for (FileListFilter<F> fileFilter : this.fileFilters) {
            List<F> currentResults = fileFilter.filterFiles(files);
            results.retainAll(currentResults);
        }
        return results;
    }

    @Override
    public void rollback(F file, List<F> files) {
        for (FileListFilter<F> fileFilter : this.fileFilters) {
            if (!(fileFilter instanceof ReversibleFileListFilter)) continue;
            ((ReversibleFileListFilter)fileFilter).rollback(file, files);
        }
    }
}

