/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.synchronizer;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.expression.IntegrationEvaluationContextAware;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.ReversibleFileListFilter;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.SessionCallback;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.synchronizer.InboundFileSynchronizer;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractInboundFileSynchronizer<F>
implements InboundFileSynchronizer,
InitializingBean,
IntegrationEvaluationContextAware,
Closeable {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final RemoteFileTemplate<F> remoteFileTemplate;
    private volatile EvaluationContext evaluationContext;
    private volatile String remoteFileSeparator = "/";
    private volatile String temporaryFileSuffix = ".writing";
    private volatile Expression localFilenameGeneratorExpression;
    private volatile String remoteDirectory;
    private volatile FileListFilter<F> filter;
    private volatile boolean deleteRemoteFiles;
    private volatile boolean preserveTimestamp;

    public AbstractInboundFileSynchronizer(SessionFactory<F> sessionFactory) {
        Assert.notNull(sessionFactory, (String)"sessionFactory must not be null");
        this.remoteFileTemplate = new RemoteFileTemplate<F>(sessionFactory);
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        Assert.notNull((Object)remoteFileSeparator, (String)"'remoteFileSeparator' must not be null");
        this.remoteFileSeparator = remoteFileSeparator;
    }

    public void setLocalFilenameGeneratorExpression(Expression localFilenameGeneratorExpression) {
        Assert.notNull((Object)localFilenameGeneratorExpression, (String)"'localFilenameGeneratorExpression' must not be null");
        this.localFilenameGeneratorExpression = localFilenameGeneratorExpression;
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        this.temporaryFileSuffix = temporaryFileSuffix;
    }

    public void setRemoteDirectory(String remoteDirectory) {
        this.remoteDirectory = remoteDirectory;
    }

    public void setFilter(FileListFilter<F> filter) {
        this.filter = filter;
    }

    public void setDeleteRemoteFiles(boolean deleteRemoteFiles) {
        this.deleteRemoteFiles = deleteRemoteFiles;
    }

    public void setPreserveTimestamp(boolean preserveTimestamp) {
        this.preserveTimestamp = preserveTimestamp;
    }

    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public final void afterPropertiesSet() {
        Assert.notNull((Object)this.remoteDirectory, (String)"remoteDirectory must not be null");
        Assert.notNull((Object)this.evaluationContext, (String)"evaluationContext must not be null");
    }

    protected final List<F> filterFiles(F[] files) {
        return this.filter != null ? this.filter.filterFiles(files) : Arrays.asList(files);
    }

    protected String getTemporaryFileSuffix() {
        return this.temporaryFileSuffix;
    }

    @Override
    public void close() throws IOException {
        if (this.filter instanceof Closeable) {
            ((Closeable)((Object)this.filter)).close();
        }
    }

    @Override
    public void synchronizeToLocalDirectory(final File localDirectory) {
        try {
            int transferred = (Integer)this.remoteFileTemplate.execute(new SessionCallback<F, Integer>(){

                @Override
                public Integer doInSession(Session<F> session) throws IOException {
                    Object[] files = session.list(AbstractInboundFileSynchronizer.this.remoteDirectory);
                    if (!ObjectUtils.isEmpty((Object[])files)) {
                        List<Object> filteredFiles = AbstractInboundFileSynchronizer.this.filterFiles(files);
                        for (Object file : filteredFiles) {
                            try {
                                if (file == null) continue;
                                AbstractInboundFileSynchronizer.this.copyFileToLocalDirectory(AbstractInboundFileSynchronizer.this.remoteDirectory, file, localDirectory, session);
                            }
                            catch (RuntimeException e) {
                                if (AbstractInboundFileSynchronizer.this.filter instanceof ReversibleFileListFilter) {
                                    ((ReversibleFileListFilter)AbstractInboundFileSynchronizer.this.filter).rollback(file, filteredFiles);
                                }
                                throw e;
                            }
                            catch (IOException e) {
                                if (AbstractInboundFileSynchronizer.this.filter instanceof ReversibleFileListFilter) {
                                    ((ReversibleFileListFilter)AbstractInboundFileSynchronizer.this.filter).rollback(file, filteredFiles);
                                }
                                throw e;
                            }
                        }
                        return filteredFiles.size();
                    }
                    return 0;
                }
            });
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(transferred + " files transferred"));
            }
        }
        catch (Exception e) {
            throw new MessagingException("Problem occurred while synchronizing remote to local directory", (Throwable)e);
        }
    }

    protected void copyFileToLocalDirectory(String remoteDirectoryPath, F remoteFile, File localDirectory, Session<F> session) throws IOException {
        String remoteFileName = this.getFilename(remoteFile);
        String localFileName = this.generateLocalFileName(remoteFileName);
        String remoteFilePath = remoteDirectoryPath + this.remoteFileSeparator + remoteFileName;
        if (!this.isFile(remoteFile)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("cannot copy, not a file: " + remoteFilePath));
            }
            return;
        }
        File localFile = new File(localDirectory, localFileName);
        if (!localFile.exists()) {
            String tempFileName = localFile.getAbsolutePath() + this.temporaryFileSuffix;
            File tempFile = new File(tempFileName);
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(tempFile));
            try {
                session.read(remoteFilePath, outputStream);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new MessagingException("Failure occurred while copying from remote to local directory", (Throwable)e);
            }
            finally {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Exception exception) {}
            }
            if (tempFile.renameTo(localFile) && this.deleteRemoteFiles) {
                session.remove(remoteFilePath);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("deleted " + remoteFilePath));
                }
            }
            if (this.preserveTimestamp) {
                localFile.setLastModified(this.getModified(remoteFile));
            }
        }
    }

    private String generateLocalFileName(String remoteFileName) {
        if (this.localFilenameGeneratorExpression != null) {
            return (String)this.localFilenameGeneratorExpression.getValue(this.evaluationContext, (Object)remoteFileName, String.class);
        }
        return remoteFileName;
    }

    protected abstract boolean isFile(F var1);

    protected abstract String getFilename(F var1);

    protected abstract long getModified(F var1);
}

