/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.support.locks.DefaultLockRegistry;
import org.springframework.integration.support.locks.LockRegistry;
import org.springframework.integration.support.locks.PassThruLockRegistry;
import org.springframework.integration.util.WhileLockedProcessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FileWritingMessageHandler
extends AbstractReplyProducingMessageHandler {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private volatile String temporaryFileSuffix = ".writing";
    private volatile boolean temporaryFileSuffixSet = false;
    private volatile FileExistsMode fileExistsMode = FileExistsMode.REPLACE;
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private volatile FileNameGenerator fileNameGenerator = new DefaultFileNameGenerator();
    private volatile boolean fileNameGeneratorSet;
    private volatile StandardEvaluationContext evaluationContext;
    private final Expression destinationDirectoryExpression;
    private volatile boolean autoCreateDirectory = true;
    private volatile boolean deleteSourceFiles;
    private volatile Charset charset = Charset.defaultCharset();
    private volatile boolean expectReply = true;
    private volatile boolean appendNewLine = false;
    private volatile LockRegistry lockRegistry = new PassThruLockRegistry();

    public FileWritingMessageHandler(File destinationDirectory) {
        Assert.notNull((Object)destinationDirectory, (String)"Destination directory must not be null.");
        this.destinationDirectoryExpression = new LiteralExpression(destinationDirectory.getPath());
    }

    public FileWritingMessageHandler(Expression destinationDirectoryExpression) {
        Assert.notNull((Object)destinationDirectoryExpression, (String)"Destination directory expression must not be null.");
        this.destinationDirectoryExpression = destinationDirectoryExpression;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        Assert.notNull((Object)temporaryFileSuffix, (String)"'temporaryFileSuffix' must not be null");
        this.temporaryFileSuffix = temporaryFileSuffix;
        this.temporaryFileSuffixSet = true;
    }

    public void setFileExistsMode(FileExistsMode fileExistsMode) {
        Assert.notNull((Object)((Object)fileExistsMode), (String)"'fileExistsMode' must not be null.");
        this.fileExistsMode = fileExistsMode;
        if (FileExistsMode.APPEND.equals((Object)fileExistsMode)) {
            this.lockRegistry = this.lockRegistry instanceof PassThruLockRegistry ? new DefaultLockRegistry() : this.lockRegistry;
        }
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setAppendNewLine(boolean appendNewLine) {
        this.appendNewLine = appendNewLine;
    }

    protected String getTemporaryFileSuffix() {
        return this.temporaryFileSuffix;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        Assert.notNull((Object)fileNameGenerator, (String)"FileNameGenerator must not be null");
        this.fileNameGenerator = fileNameGenerator;
        this.fileNameGeneratorSet = true;
    }

    public void setDeleteSourceFiles(boolean deleteSourceFiles) {
        this.deleteSourceFiles = deleteSourceFiles;
    }

    public void setCharset(String charset) {
        Assert.notNull((Object)charset, (String)"charset must not be null");
        Assert.isTrue((boolean)Charset.isSupported(charset), (String)("Charset '" + charset + "' is not supported."));
        this.charset = Charset.forName(charset);
    }

    protected void doInit() {
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        if (this.destinationDirectoryExpression instanceof LiteralExpression) {
            File directory = new File((String)this.destinationDirectoryExpression.getValue((EvaluationContext)this.evaluationContext, null, String.class));
            this.validateDestinationDirectory(directory, this.autoCreateDirectory);
        }
        if (!this.fileNameGeneratorSet && this.fileNameGenerator instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.fileNameGenerator).setBeanFactory(this.getBeanFactory());
        }
    }

    private void validateDestinationDirectory(File destinationDirectory, boolean autoCreateDirectory) {
        if (!destinationDirectory.exists() && autoCreateDirectory) {
            Assert.isTrue((boolean)destinationDirectory.mkdirs(), (String)("Destination directory [" + destinationDirectory + "] could not be created."));
        }
        Assert.isTrue((boolean)destinationDirectory.exists(), (String)("Destination directory [" + destinationDirectory + "] does not exist."));
        Assert.isTrue((boolean)destinationDirectory.isDirectory(), (String)("Destination path [" + destinationDirectory + "] does not point to a directory."));
        Assert.isTrue((boolean)destinationDirectory.canWrite(), (String)("Destination directory [" + destinationDirectory + "] is not writable."));
        Assert.state((!this.temporaryFileSuffixSet || !FileExistsMode.APPEND.equals((Object)this.fileExistsMode) ? 1 : 0) != 0, (String)"'temporaryFileSuffix' can not be set when appending to an existing file");
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        File resultFile;
        File originalFileFromHeader;
        Object payload;
        block9: {
            boolean ignore;
            Assert.notNull(requestMessage, (String)"message must not be null");
            payload = requestMessage.getPayload();
            Assert.notNull((Object)payload, (String)"message payload must not be null");
            String generatedFileName = this.fileNameGenerator.generateFileName(requestMessage);
            originalFileFromHeader = this.retrieveOriginalFileFromHeader(requestMessage);
            File destinationDirectoryToUse = this.evaluateDestinationDirectoryExpression(requestMessage);
            File tempFile = new File(destinationDirectoryToUse, generatedFileName + this.temporaryFileSuffix);
            resultFile = new File(destinationDirectoryToUse, generatedFileName);
            if (FileExistsMode.FAIL.equals((Object)this.fileExistsMode) && resultFile.exists()) {
                throw new MessageHandlingException(requestMessage, "The destination file already exists at '" + resultFile.getAbsolutePath() + "'.");
            }
            boolean bl = ignore = FileExistsMode.IGNORE.equals((Object)this.fileExistsMode) && (resultFile.exists() || StringUtils.hasText((String)this.temporaryFileSuffix) && tempFile.exists());
            if (!ignore) {
                try {
                    if (payload instanceof File) {
                        resultFile = this.handleFileMessage((File)payload, tempFile, resultFile);
                        break block9;
                    }
                    if (payload instanceof byte[]) {
                        resultFile = this.handleByteArrayMessage((byte[])payload, originalFileFromHeader, tempFile, resultFile);
                        break block9;
                    }
                    if (payload instanceof String) {
                        resultFile = this.handleStringMessage((String)payload, originalFileFromHeader, tempFile, resultFile);
                        break block9;
                    }
                    throw new IllegalArgumentException("unsupported Message payload type [" + payload.getClass().getName() + "]");
                }
                catch (Exception e) {
                    throw new MessageHandlingException(requestMessage, "failed to write Message payload to file", (Throwable)e);
                }
            }
        }
        if (!this.expectReply) {
            return null;
        }
        if (resultFile != null && originalFileFromHeader == null && payload instanceof File) {
            return this.getMessageBuilderFactory().withPayload((Object)resultFile).setHeader("file_originalFile", payload);
        }
        return resultFile;
    }

    private File retrieveOriginalFileFromHeader(Message<?> message) {
        Object value = message.getHeaders().get((Object)"file_originalFile");
        if (value instanceof File) {
            return (File)value;
        }
        if (value instanceof String) {
            return new File((String)value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File handleFileMessage(File sourceFile, File tempFile, File resultFile) throws IOException {
        if (FileExistsMode.APPEND.equals((Object)this.fileExistsMode)) {
            File fileToWriteTo = this.determineFileToWrite(resultFile, tempFile);
            final BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileToWriteTo, true));
            final BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile));
            WhileLockedProcessor whileLockedProcessor = new WhileLockedProcessor(this.lockRegistry, fileToWriteTo.getAbsolutePath()){

                protected void whileLocked() throws IOException {
                    try {
                        byte[] buffer = new byte[4096];
                        int bytesRead = -1;
                        while ((bytesRead = bis.read(buffer)) != -1) {
                            bos.write(buffer, 0, bytesRead);
                        }
                        if (FileWritingMessageHandler.this.appendNewLine) {
                            bos.write(LINE_SEPARATOR.getBytes());
                        }
                        bos.flush();
                    }
                    finally {
                        try {
                            bis.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            bos.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            };
            whileLockedProcessor.doWhileLocked();
            this.cleanUpAfterCopy(fileToWriteTo, resultFile, sourceFile);
            return resultFile;
        }
        if (this.deleteSourceFiles) {
            if (sourceFile.renameTo(resultFile)) {
                return resultFile;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)String.format("Failed to move file '%s'. Using copy and delete fallback.", sourceFile.getAbsolutePath()));
            }
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tempFile));
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile));
        try {
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, bytesRead);
            }
            if (this.appendNewLine) {
                bos.write(LINE_SEPARATOR.getBytes());
            }
            bos.flush();
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException iOException) {}
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
        this.cleanUpAfterCopy(tempFile, resultFile, sourceFile);
        return resultFile;
    }

    private File handleByteArrayMessage(final byte[] bytes, File originalFile, File tempFile, File resultFile) throws IOException {
        File fileToWriteTo = this.determineFileToWrite(resultFile, tempFile);
        boolean append = FileExistsMode.APPEND.equals((Object)this.fileExistsMode);
        final BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileToWriteTo, append));
        WhileLockedProcessor whileLockedProcessor = new WhileLockedProcessor(this.lockRegistry, fileToWriteTo.getAbsolutePath()){

            protected void whileLocked() throws IOException {
                try {
                    bos.write(bytes);
                    if (FileWritingMessageHandler.this.appendNewLine) {
                        bos.write(LINE_SEPARATOR.getBytes());
                    }
                }
                finally {
                    try {
                        bos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        whileLockedProcessor.doWhileLocked();
        this.cleanUpAfterCopy(fileToWriteTo, resultFile, originalFile);
        return resultFile;
    }

    private File handleStringMessage(final String content, File originalFile, File tempFile, File resultFile) throws IOException {
        File fileToWriteTo = this.determineFileToWrite(resultFile, tempFile);
        boolean append = FileExistsMode.APPEND.equals((Object)this.fileExistsMode);
        final BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileToWriteTo, append), this.charset));
        WhileLockedProcessor whileLockedProcessor = new WhileLockedProcessor(this.lockRegistry, fileToWriteTo.getAbsolutePath()){

            protected void whileLocked() throws IOException {
                try {
                    writer.write(content);
                    if (FileWritingMessageHandler.this.appendNewLine) {
                        writer.newLine();
                    }
                }
                finally {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        whileLockedProcessor.doWhileLocked();
        this.cleanUpAfterCopy(fileToWriteTo, resultFile, originalFile);
        return resultFile;
    }

    private File determineFileToWrite(File resultFile, File tempFile) {
        File fileToWriteTo;
        switch (this.fileExistsMode) {
            case APPEND: {
                fileToWriteTo = resultFile;
                break;
            }
            case FAIL: 
            case IGNORE: 
            case REPLACE: {
                fileToWriteTo = tempFile;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported FileExistsMode " + (Object)((Object)this.fileExistsMode));
            }
        }
        return fileToWriteTo;
    }

    private void cleanUpAfterCopy(File fileToWriteTo, File resultFile, File originalFile) throws IOException {
        if (!FileExistsMode.APPEND.equals((Object)this.fileExistsMode) && StringUtils.hasText((String)this.temporaryFileSuffix)) {
            this.renameTo(fileToWriteTo, resultFile);
        }
        if (this.deleteSourceFiles && originalFile != null) {
            originalFile.delete();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void renameTo(File tempFile, File resultFile) throws IOException {
        Assert.notNull((Object)resultFile, (String)"'resultFile' must not be null");
        Assert.notNull((Object)tempFile, (String)"'tempFile' must not be null");
        if (resultFile.exists()) {
            if (!resultFile.setWritable(true, false) || !resultFile.delete()) throw new IOException("Failed to rename file '" + tempFile.getAbsolutePath() + "' to '" + resultFile.getAbsolutePath() + "' since '" + resultFile.getName() + "' is not writable or can not be deleted");
            if (tempFile.renameTo(resultFile)) return;
            throw new IOException("Failed to rename file '" + tempFile.getAbsolutePath() + "' to '" + resultFile.getAbsolutePath() + "'");
        }
        if (tempFile.renameTo(resultFile)) return;
        throw new IOException("Failed to rename file '" + tempFile.getAbsolutePath() + "' to '" + resultFile.getAbsolutePath() + "'");
    }

    private File evaluateDestinationDirectoryExpression(Message<?> message) {
        File destinationDirectory;
        Object destinationDirectoryToUse = this.destinationDirectoryExpression.getValue((EvaluationContext)this.evaluationContext, message);
        if (destinationDirectoryToUse == null) {
            throw new IllegalStateException(String.format("The provided destinationDirectoryExpression (%s) must not resolve to null.", this.destinationDirectoryExpression.getExpressionString()));
        }
        if (destinationDirectoryToUse instanceof String) {
            String destinationDirectoryPath = (String)destinationDirectoryToUse;
            Assert.hasText((String)destinationDirectoryPath, (String)String.format("Unable to resolve destination directory name for the provided Expression '%s'.", this.destinationDirectoryExpression.getExpressionString()));
            destinationDirectory = new File(destinationDirectoryPath);
        } else if (destinationDirectoryToUse instanceof File) {
            destinationDirectory = (File)destinationDirectoryToUse;
        } else {
            throw new IllegalStateException(String.format("The provided destinationDirectoryExpression (%s) must be of type java.io.File or be a String.", this.destinationDirectoryExpression.getExpressionString()));
        }
        this.validateDestinationDirectory(destinationDirectory, this.autoCreateDirectory);
        return destinationDirectory;
    }
}

