/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.gateway;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.SessionCallback;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractRemoteFileOutboundGateway<F>
extends AbstractReplyProducingMessageHandler {
    private final RemoteFileTemplate<F> remoteFileTemplate;
    protected final Command command;
    private final ExpressionEvaluatingMessageProcessor<String> fileNameProcessor;
    private volatile ExpressionEvaluatingMessageProcessor<String> renameProcessor = new ExpressionEvaluatingMessageProcessor(new SpelExpressionParser().parseExpression("headers.file_renameTo"));
    protected volatile Set<Option> options = new HashSet<Option>();
    private volatile Expression localDirectoryExpression;
    private volatile boolean autoCreateLocalDirectory = true;
    private volatile FileListFilter<F> filter;
    private volatile FileListFilter<File> mputFilter;
    private volatile Expression localFilenameGeneratorExpression;

    public AbstractRemoteFileOutboundGateway(SessionFactory<F> sessionFactory, String command, String expression) {
        Assert.notNull(sessionFactory, (String)"'sessionFactory' cannot be null");
        this.remoteFileTemplate = new RemoteFileTemplate<F>(sessionFactory);
        this.command = Command.toCommand(command);
        this.fileNameProcessor = new ExpressionEvaluatingMessageProcessor(new SpelExpressionParser().parseExpression(expression));
    }

    public AbstractRemoteFileOutboundGateway(SessionFactory<F> sessionFactory, Command command, String expression) {
        Assert.notNull(sessionFactory, (String)"'sessionFactory' cannot be null");
        this.remoteFileTemplate = new RemoteFileTemplate<F>(sessionFactory);
        this.command = command;
        this.fileNameProcessor = new ExpressionEvaluatingMessageProcessor(new SpelExpressionParser().parseExpression(expression));
    }

    public AbstractRemoteFileOutboundGateway(RemoteFileTemplate<F> remoteFileTemplate, String command, String expression) {
        Assert.notNull(remoteFileTemplate, (String)"'remoteFileTemplate' cannot be null");
        this.remoteFileTemplate = remoteFileTemplate;
        this.command = Command.toCommand(command);
        this.fileNameProcessor = new ExpressionEvaluatingMessageProcessor(new SpelExpressionParser().parseExpression(expression));
    }

    public AbstractRemoteFileOutboundGateway(RemoteFileTemplate<F> remoteFileTemplate, Command command, String expression) {
        Assert.notNull(remoteFileTemplate, (String)"'remoteFileTemplate' cannot be null");
        this.remoteFileTemplate = remoteFileTemplate;
        this.command = command;
        this.fileNameProcessor = new ExpressionEvaluatingMessageProcessor(new SpelExpressionParser().parseExpression(expression));
    }

    public void setOptions(String options) {
        String[] opts;
        for (String opt : opts = options.split("\\s")) {
            String trimmedOpt = opt.trim();
            if (!StringUtils.hasLength((String)trimmedOpt)) continue;
            this.options.add(Option.toOption(trimmedOpt));
        }
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        this.remoteFileTemplate.setRemoteFileSeparator(remoteFileSeparator);
    }

    public void setLocalDirectory(File localDirectory) {
        if (localDirectory != null) {
            this.localDirectoryExpression = new LiteralExpression(localDirectory.getAbsolutePath());
        }
    }

    public void setLocalDirectoryExpression(Expression localDirectoryExpression) {
        this.localDirectoryExpression = localDirectoryExpression;
    }

    public void setAutoCreateLocalDirectory(boolean autoCreateLocalDirectory) {
        this.autoCreateLocalDirectory = autoCreateLocalDirectory;
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        this.remoteFileTemplate.setTemporaryFileSuffix(temporaryFileSuffix);
    }

    public void setFilter(FileListFilter<F> filter) {
        this.filter = filter;
    }

    public void setMputFilter(FileListFilter<File> filter) {
        this.mputFilter = filter;
    }

    @Deprecated
    public void setRenameExpression(String expression) {
        Assert.notNull((Object)expression, (String)"'expression' cannot be null");
        this.setExpressionRename(new SpelExpressionParser().parseExpression(expression));
    }

    public void setExpressionRename(Expression expression) {
        Assert.notNull((Object)expression, (String)"'expression' cannot be null");
        this.renameProcessor = new ExpressionEvaluatingMessageProcessor(expression);
    }

    public void setLocalFilenameGeneratorExpression(Expression localFilenameGeneratorExpression) {
        Assert.notNull((Object)localFilenameGeneratorExpression, (String)"'localFilenameGeneratorExpression' must not be null");
        this.localFilenameGeneratorExpression = localFilenameGeneratorExpression;
    }

    protected void doInit() {
        block11: {
            Assert.notNull((Object)((Object)this.command), (String)"command must not be null");
            if (Command.RM.equals((Object)this.command) || Command.GET.equals((Object)this.command)) {
                Assert.isNull(this.filter, (String)"Filters are not supported with the rm and get commands");
            }
            if (Command.GET.equals((Object)this.command) || Command.MGET.equals((Object)this.command)) {
                Assert.notNull((Object)this.localDirectoryExpression, (String)"localDirectory must not be null");
                if (this.localDirectoryExpression instanceof LiteralExpression) {
                    File localDirectory = new File(this.localDirectoryExpression.getExpressionString());
                    try {
                        if (localDirectory.exists()) break block11;
                        if (this.autoCreateLocalDirectory) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("The '" + localDirectory + "' directory doesn't exist; Will create."));
                            }
                            if (!localDirectory.mkdirs()) {
                                throw new IOException("Failed to make local directory: " + localDirectory);
                            }
                            break block11;
                        }
                        throw new FileNotFoundException(localDirectory.getName());
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new MessagingException("Failure during initialization of: " + this.getComponentType(), (Throwable)e);
                    }
                }
            }
        }
        if (Command.MGET.equals((Object)this.command)) {
            Assert.isTrue((!this.options.contains((Object)Option.SUBDIRS) ? 1 : 0) != 0, (String)("Cannot use " + Option.SUBDIRS.toString() + " when using 'mget' use " + Option.RECURSIVE.toString() + " to obtain files in subdirectories"));
        }
        if (this.getBeanFactory() != null) {
            this.fileNameProcessor.setBeanFactory(this.getBeanFactory());
            this.renameProcessor.setBeanFactory(this.getBeanFactory());
            this.remoteFileTemplate.setBeanFactory(this.getBeanFactory());
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        switch (this.command) {
            case LS: {
                return this.doLs(requestMessage);
            }
            case GET: {
                return this.doGet(requestMessage);
            }
            case MGET: {
                return this.doMget(requestMessage);
            }
            case RM: {
                return this.doRm(requestMessage);
            }
            case MV: {
                return this.doMv(requestMessage);
            }
            case PUT: {
                return this.doPut(requestMessage);
            }
            case MPUT: {
                return this.doMput(requestMessage);
            }
        }
        return null;
    }

    private Object doLs(Message<?> requestMessage) {
        String dir = (String)this.fileNameProcessor.processMessage(requestMessage);
        if (!dir.endsWith(this.remoteFileTemplate.getRemoteFileSeparator())) {
            dir = dir + this.remoteFileTemplate.getRemoteFileSeparator();
        }
        final String fullDir = dir;
        List payload = (List)this.remoteFileTemplate.execute(new SessionCallback<F, List<?>>(){

            @Override
            public List<?> doInSession(Session<F> session) throws IOException {
                return AbstractRemoteFileOutboundGateway.this.ls(session, fullDir);
            }
        });
        return this.getMessageBuilderFactory().withPayload((Object)payload).setHeader("file_remoteDirectory", (Object)dir).build();
    }

    private Object doGet(final Message<?> requestMessage) {
        final String remoteFilePath = (String)this.fileNameProcessor.processMessage(requestMessage);
        final String remoteFilename = this.getRemoteFilename(remoteFilePath);
        final String remoteDir = this.getRemoteDirectory(remoteFilePath, remoteFilename);
        File payload = (File)this.remoteFileTemplate.execute(new SessionCallback<F, File>(){

            @Override
            public File doInSession(Session<F> session) throws IOException {
                return AbstractRemoteFileOutboundGateway.this.get(requestMessage, session, remoteDir, remoteFilePath, remoteFilename, true);
            }
        });
        return this.getMessageBuilderFactory().withPayload((Object)payload).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).build();
    }

    private Object doMget(final Message<?> requestMessage) {
        String remoteFilePath = (String)this.fileNameProcessor.processMessage(requestMessage);
        final String remoteFilename = this.getRemoteFilename(remoteFilePath);
        final String remoteDir = this.getRemoteDirectory(remoteFilePath, remoteFilename);
        List payload = (List)this.remoteFileTemplate.execute(new SessionCallback<F, List<File>>(){

            @Override
            public List<File> doInSession(Session<F> session) throws IOException {
                return AbstractRemoteFileOutboundGateway.this.mGet(requestMessage, session, remoteDir, remoteFilename);
            }
        });
        return this.getMessageBuilderFactory().withPayload((Object)payload).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).build();
    }

    private Object doRm(Message<?> requestMessage) {
        String remoteFilePath = (String)this.fileNameProcessor.processMessage(requestMessage);
        String remoteFilename = this.getRemoteFilename(remoteFilePath);
        String remoteDir = this.getRemoteDirectory(remoteFilePath, remoteFilename);
        boolean payload = this.remoteFileTemplate.remove(remoteFilePath);
        return this.getMessageBuilderFactory().withPayload((Object)payload).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).build();
    }

    private Object doMv(Message<?> requestMessage) {
        String remoteFilePath = (String)this.fileNameProcessor.processMessage(requestMessage);
        String remoteFilename = this.getRemoteFilename(remoteFilePath);
        String remoteDir = this.getRemoteDirectory(remoteFilePath, remoteFilename);
        String remoteFileNewPath = (String)this.renameProcessor.processMessage(requestMessage);
        Assert.hasLength((String)remoteFileNewPath, (String)"New filename cannot be empty");
        this.remoteFileTemplate.rename(remoteFilePath, remoteFileNewPath);
        return this.getMessageBuilderFactory().withPayload((Object)Boolean.TRUE).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).setHeader("file_renameTo", (Object)remoteFileNewPath).build();
    }

    private String doPut(Message<?> requestMessage) {
        return this.doPut(requestMessage, null);
    }

    private String doPut(Message<?> requestMessage, String subDirectory) {
        String path = this.remoteFileTemplate.send(requestMessage, subDirectory, new FileExistsMode[0]);
        if (path == null) {
            throw new MessagingException(requestMessage, "No local file found for " + requestMessage);
        }
        return path;
    }

    private Object doMput(Message<?> requestMessage) {
        File file = null;
        if (requestMessage.getPayload() instanceof File) {
            file = (File)requestMessage.getPayload();
        } else if (requestMessage.getPayload() instanceof String) {
            file = new File((String)requestMessage.getPayload());
        } else {
            throw new IllegalArgumentException("Only File or String payloads allowed for 'mput'");
        }
        if (!file.isDirectory()) {
            return this.doPut(requestMessage);
        }
        List<String> replies = this.putLocalDirectory(requestMessage, file, null);
        return replies;
    }

    private List<String> putLocalDirectory(Message<?> requestMessage, File file, String subDirectory) {
        File[] files = file.listFiles();
        List<File> filteredFiles = this.filterMputFiles(files);
        ArrayList<String> replies = new ArrayList<String>();
        for (File filteredFile : filteredFiles) {
            if (!filteredFile.isDirectory()) {
                String path = this.doPut(this.getMessageBuilderFactory().withPayload((Object)filteredFile).copyHeaders((Map)requestMessage.getHeaders()).build(), subDirectory);
                if (path == null) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("File " + filteredFile.getAbsolutePath() + " removed before transfer; ignoring"));
                    continue;
                }
                replies.add(path);
                continue;
            }
            if (!this.options.contains((Object)Option.RECURSIVE)) continue;
            String newSubDirectory = (StringUtils.hasText((String)subDirectory) ? subDirectory + this.remoteFileTemplate.getRemoteFileSeparator() : "") + filteredFile.getName();
            replies.addAll(this.putLocalDirectory(requestMessage, filteredFile, newSubDirectory));
        }
        return replies;
    }

    protected List<?> ls(Session<F> session, String dir) throws IOException {
        List<F> lsFiles = this.listFilesInRemoteDir(session, dir, "");
        if (!this.options.contains((Object)Option.LINKS)) {
            this.purgeLinks(lsFiles);
        }
        if (!this.options.contains((Object)Option.ALL)) {
            this.purgeDots(lsFiles);
        }
        if (this.options.contains((Object)Option.NAME_ONLY)) {
            ArrayList<String> results = new ArrayList<String>();
            for (F file : lsFiles) {
                results.add(this.getFilename(file));
            }
            if (!this.options.contains((Object)Option.NOSORT)) {
                Collections.sort(results);
            }
            return results;
        }
        List<AbstractFileInfo<F>> canonicalFiles = this.asFileInfoList(lsFiles);
        for (AbstractFileInfo<F> file : canonicalFiles) {
            file.setRemoteDirectory(dir);
        }
        if (!this.options.contains((Object)Option.NOSORT)) {
            Collections.sort(canonicalFiles);
        }
        return canonicalFiles;
    }

    private List<F> listFilesInRemoteDir(Session<F> session, String directory, String subDirectory) throws IOException {
        ArrayList<Object> lsFiles = new ArrayList<Object>();
        Object[] files = session.list(directory + subDirectory);
        boolean recursion = this.options.contains((Object)Option.RECURSIVE);
        if (!ObjectUtils.isEmpty((Object[])files)) {
            List<Object> filteredFiles = this.filterFiles(files);
            for (Object e : filteredFiles) {
                String fileName = this.getFilename(e);
                if (e == null) continue;
                if (this.options.contains((Object)Option.SUBDIRS) || !this.isDirectory(e)) {
                    if (recursion && StringUtils.hasText((String)subDirectory)) {
                        lsFiles.add(this.enhanceNameWithSubDirectory(e, subDirectory));
                    } else {
                        lsFiles.add(e);
                    }
                }
                if (!recursion || !this.isDirectory(e) || ".".equals(fileName) || "..".equals(fileName)) continue;
                lsFiles.addAll(this.listFilesInRemoteDir(session, directory, subDirectory + fileName + this.remoteFileTemplate.getRemoteFileSeparator()));
            }
        }
        return lsFiles;
    }

    protected final List<F> filterFiles(F[] files) {
        return this.filter != null ? this.filter.filterFiles(files) : Arrays.asList(files);
    }

    protected final List<File> filterMputFiles(File[] files) {
        if (files == null) {
            return Collections.emptyList();
        }
        return this.mputFilter != null ? this.mputFilter.filterFiles((File[])files) : Arrays.asList(files);
    }

    protected void purgeLinks(List<F> lsFiles) {
        Iterator<F> iterator = lsFiles.iterator();
        while (iterator.hasNext()) {
            if (!this.isLink(iterator.next())) continue;
            iterator.remove();
        }
    }

    protected void purgeDots(List<F> lsFiles) {
        Iterator<F> iterator = lsFiles.iterator();
        while (iterator.hasNext()) {
            if (!this.getFilename(iterator.next()).startsWith(".")) continue;
            iterator.remove();
        }
    }

    protected File get(Message<?> message, Session<F> session, String remoteDir, String remoteFilePath, String remoteFilename, boolean lsFirst) throws IOException {
        File localFile;
        F[] files = null;
        if (lsFirst) {
            files = session.list(remoteFilePath);
            if (files == null) {
                throw new MessagingException("Session returned null when listing " + remoteFilePath);
            }
            if (files.length != 1 || this.isDirectory(files[0]) || this.isLink(files[0])) {
                throw new MessagingException(remoteFilePath + " is not a file");
            }
        }
        if (!(localFile = new File(this.generateLocalDirectory(message, remoteDir), this.generateLocalFileName(message, remoteFilename))).exists()) {
            String tempFileName = localFile.getAbsolutePath() + this.remoteFileTemplate.getTemporaryFileSuffix();
            File tempFile = new File(tempFileName);
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(tempFile));
            try {
                session.read(remoteFilePath, outputStream);
            }
            catch (Exception e) {
                outputStream.close();
                tempFile.delete();
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new MessagingException("Failure occurred while copying from remote to local directory", (Throwable)e);
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (Exception ignored2) {}
            }
            if (!tempFile.renameTo(localFile)) {
                throw new MessagingException("Failed to rename local file");
            }
            if (lsFirst && this.options.contains((Object)Option.PRESERVE_TIMESTAMP)) {
                localFile.setLastModified(this.getModified(files[0]));
            }
            return localFile;
        }
        throw new MessagingException("Local file " + localFile + " already exists");
    }

    protected List<File> mGet(Message<?> message, Session<F> session, String remoteDirectory, String remoteFilename) throws IOException {
        if (this.options.contains((Object)Option.RECURSIVE)) {
            if (this.logger.isWarnEnabled() && !"*".equals(remoteFilename)) {
                this.logger.warn((Object)"File name pattern must be '*' when using recursion");
            }
            if (this.options.contains((Object)Option.NAME_ONLY)) {
                this.options.remove((Object)Option.NAME_ONLY);
            }
            return this.mGetWithRecursion(message, session, remoteDirectory, remoteFilename);
        }
        return this.mGetWithoutRecursion(message, session, remoteDirectory, remoteFilename);
    }

    private List<File> mGetWithoutRecursion(Message<?> message, Session<F> session, String remoteDirectory, String remoteFilename) throws IOException {
        String path = this.generateFullPath(remoteDirectory, remoteFilename);
        String[] fileNames = session.listNames(path);
        if (fileNames == null) {
            fileNames = new String[]{};
        }
        if (fileNames.length == 0 && this.options.contains((Object)Option.EXCEPTION_WHEN_EMPTY)) {
            throw new MessagingException("No files found at " + remoteDirectory + " with pattern " + remoteFilename);
        }
        ArrayList<File> files = new ArrayList<File>();
        String remoteFileSeparator = this.remoteFileTemplate.getRemoteFileSeparator();
        for (String fileName : fileNames) {
            File file = fileName.contains(remoteFileSeparator) && fileName.startsWith(remoteDirectory) ? this.get(message, session, remoteDirectory, fileName, fileName.substring(fileName.lastIndexOf(remoteFileSeparator)), false) : this.get(message, session, remoteDirectory, this.generateFullPath(remoteDirectory, fileName), fileName, false);
            files.add(file);
        }
        return files;
    }

    private List<File> mGetWithRecursion(Message<?> message, Session<F> session, String remoteDirectory, String remoteFilename) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        List<?> fileNames = this.ls(session, remoteDirectory);
        if (fileNames.size() == 0 && this.options.contains((Object)Option.EXCEPTION_WHEN_EMPTY)) {
            throw new MessagingException("No files found at " + remoteDirectory + " with pattern " + remoteFilename);
        }
        for (AbstractFileInfo lsEntry : fileNames) {
            String fullFileName = remoteDirectory + this.getFilename(lsEntry);
            String fileName = this.getRemoteFilename(fullFileName);
            String actualRemoteDirectory = this.getRemoteDirectory(fullFileName, fileName);
            File file = this.get(message, session, actualRemoteDirectory, fullFileName, fileName, false);
            files.add(file);
        }
        return files;
    }

    private String getRemoteDirectory(String remoteFilePath, String remoteFilename) {
        String remoteDir = remoteFilePath.substring(0, remoteFilePath.lastIndexOf(remoteFilename));
        if (remoteDir.length() == 0) {
            remoteDir = this.remoteFileTemplate.getRemoteFileSeparator();
        }
        return remoteDir;
    }

    private String generateFullPath(String remoteDirectory, String remoteFilename) {
        String remoteFileSeparator = this.remoteFileTemplate.getRemoteFileSeparator();
        String path = remoteFileSeparator.equals(remoteDirectory) ? remoteFilename : (remoteDirectory.endsWith(remoteFileSeparator) ? remoteDirectory + remoteFilename : remoteDirectory + remoteFileSeparator + remoteFilename);
        return path;
    }

    protected String getRemoteFilename(String remoteFilePath) {
        int index = remoteFilePath.lastIndexOf(this.remoteFileTemplate.getRemoteFileSeparator());
        String remoteFileName = index < 0 ? remoteFilePath : remoteFilePath.substring(index + 1);
        return remoteFileName;
    }

    private File generateLocalDirectory(Message<?> message, String remoteDirectory) {
        StandardEvaluationContext evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        evaluationContext.setVariable("remoteDirectory", (Object)remoteDirectory);
        String localDirPath = (String)this.localDirectoryExpression.getValue((EvaluationContext)evaluationContext, message, String.class);
        File localDir = new File(localDirPath);
        if (!localDir.exists()) {
            Assert.isTrue((boolean)localDir.mkdirs(), (String)("Failed to make local directory: " + localDir));
        }
        return localDir;
    }

    private String generateLocalFileName(Message<?> message, String remoteFileName) {
        if (this.localFilenameGeneratorExpression != null) {
            StandardEvaluationContext evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
            evaluationContext.setVariable("remoteFileName", (Object)remoteFileName);
            return (String)this.localFilenameGeneratorExpression.getValue((EvaluationContext)evaluationContext, message, String.class);
        }
        return remoteFileName;
    }

    protected abstract boolean isDirectory(F var1);

    protected abstract boolean isLink(F var1);

    protected abstract String getFilename(F var1);

    protected abstract String getFilename(AbstractFileInfo<F> var1);

    protected abstract long getModified(F var1);

    protected abstract List<AbstractFileInfo<F>> asFileInfoList(Collection<F> var1);

    protected abstract F enhanceNameWithSubDirectory(F var1, String var2);

    public static enum Option {
        NAME_ONLY("-1"),
        ALL("-a"),
        NOSORT("-f"),
        SUBDIRS("-dirs"),
        LINKS("-links"),
        PRESERVE_TIMESTAMP("-P"),
        EXCEPTION_WHEN_EMPTY("-x"),
        RECURSIVE("-R");

        private String option;

        private Option(String option) {
            this.option = option;
        }

        public String getOption() {
            return this.option;
        }

        public static Option toOption(String opt) {
            for (Option option : Option.values()) {
                if (!option.getOption().equals(opt)) continue;
                return option;
            }
            throw new IllegalArgumentException("No option with value '" + opt + "'");
        }
    }

    public static enum Command {
        LS("ls"),
        GET("get"),
        RM("rm"),
        MGET("mget"),
        MV("mv"),
        PUT("put"),
        MPUT("mput");

        private String command;

        private Command(String command) {
            this.command = command;
        }

        public String getCommand() {
            return this.command;
        }

        public static Command toCommand(String cmd) {
            for (Command command : Command.values()) {
                if (!command.getCommand().equals(cmd)) continue;
                return command;
            }
            throw new IllegalArgumentException("No Command with value '" + cmd + "'");
        }
    }
}

