/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import java.io.File;
import java.util.Comparator;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceEditor;
import org.springframework.core.io.ResourceLoader;
import org.springframework.integration.file.FileListFilter;
import org.springframework.integration.file.FileReadingMessageSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileReadingMessageSourceFactoryBean
implements FactoryBean,
ResourceLoaderAware {
    private volatile FileReadingMessageSource source;
    private volatile ResourceLoader resourceLoader;
    private volatile String directory;
    private volatile FileListFilter filter;
    private volatile Comparator<File> comparator;
    private volatile Boolean scanEachPoll;
    private volatile Boolean autoCreateDirectory;
    private final Object initializationMonitor = new Object();

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setDirectory(String directory) {
        Assert.hasText((String)directory, (String)"directory must not be empty");
        if (directory.indexOf(58) == -1) {
            directory = "file:" + directory;
        }
        this.directory = directory;
    }

    public void setComparator(Comparator<File> comparator) {
        this.comparator = comparator;
    }

    public void setFilter(FileListFilter filter) {
        this.filter = filter;
    }

    public void setScanEachPoll(Boolean scanEachPoll) {
        this.scanEachPoll = scanEachPoll;
    }

    public void setAutoCreateDirectory(Boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public Object getObject() throws Exception {
        if (this.source == null) {
            this.initSource();
        }
        return this.source;
    }

    public Class<?> getObjectType() {
        return FileReadingMessageSource.class;
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSource() {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (this.source != null) {
                return;
            }
            this.source = this.comparator != null ? new FileReadingMessageSource(this.comparator) : new FileReadingMessageSource();
            ResourceEditor editor = new ResourceEditor(this.resourceLoader);
            editor.setAsText(this.directory);
            this.source.setInputDirectory((Resource)editor.getValue());
            if (this.filter != null) {
                this.source.setFilter(this.filter);
            }
            if (this.scanEachPoll != null) {
                this.source.setScanEachPoll(this.scanEachPoll);
            }
            if (this.autoCreateDirectory != null) {
                this.source.setAutoCreateDirectory(this.autoCreateDirectory);
            }
            this.source.afterPropertiesSet();
        }
    }
}

